/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.number;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.validator.number.MultipleOfStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.math.BigDecimal;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MultipleOf {
    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        boolean invalid;
        Number multipleOf = schema.getMultipleOf();
        if (multipleOf == null) {
            return;
        }
        MultipleOfStep step = new MultipleOfStep(schema, instance);
        Number instanceValue = this.getInstanceValue(instance);
        boolean bl = invalid = new BigDecimal(instanceValue.toString()).remainder(new BigDecimal(multipleOf.toString())).compareTo(BigDecimal.ZERO) != 0;
        if (invalid) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    private @UnknownKeyFor @NonNull @Initialized Number getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Null.nonNull(instance.asNumber());
    }
}

