/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.array;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.validator.array.UniqueItemsStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.util.Collection;
import java.util.HashSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class UniqueItems {
    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        Boolean uniqueItems = schema.isUniqueItems();
        if (uniqueItems == null) {
            return;
        }
        UniqueItemsStep step = new UniqueItemsStep(schema, instance);
        if (uniqueItems.booleanValue()) {
            Collection<Object> instanceValue = this.getInstanceValue(instance);
            HashSet<Object> items = new HashSet<Object>();
            for (Object item : instanceValue) {
                if (items.add(item)) continue;
                step.setInvalid();
                break;
            }
        }
        parentStep.add(step);
    }

    private @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Null.nonNull(instance.asCollection());
    }
}

