/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.DocumentLoader;
import io.openapiprocessor.jsonschema.schema.DocumentStore;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.JsonSchemaBoolean;
import io.openapiprocessor.jsonschema.schema.JsonSchemaContext;
import io.openapiprocessor.jsonschema.schema.JsonSchemaObject;
import io.openapiprocessor.jsonschema.schema.Keywords;
import io.openapiprocessor.jsonschema.schema.ReferenceRegistry;
import io.openapiprocessor.jsonschema.schema.Resolver;
import io.openapiprocessor.jsonschema.schema.ResolverResult;
import io.openapiprocessor.jsonschema.schema.SchemaResource;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.schema.Vocabularies;
import io.openapiprocessor.jsonschema.support.Types;
import io.openapiprocessor.jsonschema.support.Uris;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaStore {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(SchemaStore.class);
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized URI, @UnknownKeyFor @NonNull @Initialized JsonSchema> schemaCache = new HashMap<URI, JsonSchema>();
    private final @UnknownKeyFor @NonNull @Initialized DocumentStore documents = new DocumentStore();
    private final @UnknownKeyFor @NonNull @Initialized DocumentLoader loader;

    public SchemaStore(@UnknownKeyFor @NonNull @Initialized DocumentLoader loader) {
        this.loader = loader;
    }

    public void register(@UnknownKeyFor @NonNull @Initialized URI schemaUri) {
        if (this.documents.contains(schemaUri)) {
            SchemaStore.warnDuplicateId(schemaUri);
            return;
        }
        Object document = this.loader.loadDocument(schemaUri);
        this.documents.addId(schemaUri, document);
    }

    public void register(@UnknownKeyFor @NonNull @Initialized URI schemaUri, @UnknownKeyFor @NonNull @Initialized Object document) {
        if (this.documents.contains(schemaUri)) {
            SchemaStore.warnDuplicateId(schemaUri);
            return;
        }
        this.documents.addId(schemaUri, document);
    }

    public @UnknownKeyFor @NonNull @Initialized URI register(@UnknownKeyFor @NonNull @Initialized Object document) {
        URI schemaUri = this.generateUri();
        this.documents.addId(schemaUri, document);
        return schemaUri;
    }

    public void register(@UnknownKeyFor @NonNull @Initialized URI schemaUri, @UnknownKeyFor @NonNull @Initialized String resourcePath) {
        if (this.documents.contains(schemaUri)) {
            SchemaStore.warnDuplicateId(schemaUri);
            return;
        }
        Object document = this.loader.loadDocument(resourcePath);
        this.documents.addId(schemaUri, document);
    }

    public void register(@UnknownKeyFor @NonNull @Initialized SchemaVersion version) {
        this.register(version.getSchemaResource());
        version.getVocabularyResources().forEach(this::register);
    }

    public void registerDraft202012() {
        this.register(SchemaVersion.Draft202012.getSchemaResource());
        SchemaVersion.Draft202012.getVocabularyResources().forEach(this::register);
    }

    public void registerDraft201909() {
        this.register(SchemaVersion.Draft201909.getSchemaResource());
        SchemaVersion.Draft201909.getVocabularyResources().forEach(this::register);
    }

    public void registerDraft7() {
        this.register(SchemaVersion.Draft7.getSchemaResource());
    }

    public void registerDraft6() {
        this.register(SchemaVersion.Draft6.getSchemaResource());
    }

    public void registerDraft4() {
        this.register(SchemaVersion.Draft4.getSchemaResource());
    }

    private void register(@UnknownKeyFor @NonNull @Initialized SchemaResource schema) {
        this.register(schema.getUri(), schema.getResource());
    }

    public @UnknownKeyFor @NonNull @Initialized JsonSchema getSchema(@UnknownKeyFor @NonNull @Initialized URI schemaUri) {
        return this.getSchema(schemaUri, SchemaVersion.getLatest());
    }

    public @UnknownKeyFor @NonNull @Initialized JsonSchema getSchema(@UnknownKeyFor @NonNull @Initialized URI schemaUri, @UnknownKeyFor @NonNull @Initialized SchemaVersion version) {
        JsonSchema schema = this.schemaCache.get(schemaUri);
        if (schema != null) {
            return schema;
        }
        Object document = this.documents.get(schemaUri);
        if (document == null) {
            throw new RuntimeException();
        }
        Resolver resolver = new Resolver(this.documents, this.loader);
        ResolverResult resolve = resolver.resolve(schemaUri, document, new Resolver.Settings(version));
        schema = this.createSchema(schemaUri, version, resolve);
        this.schemaCache.put(schemaUri, schema);
        return schema;
    }

    private @UnknownKeyFor @NonNull @Initialized JsonSchema createSchema(@UnknownKeyFor @NonNull @Initialized URI schemaUri, @UnknownKeyFor @NonNull @Initialized SchemaVersion version, @UnknownKeyFor @NonNull @Initialized ResolverResult result) {
        Scope scope = result.getScope();
        Object document = result.getDocument();
        if (Types.isBoolean(document)) {
            Vocabularies vocabularies = Vocabularies.ALL;
            return new JsonSchemaBoolean(Types.asBoolean(document), new JsonSchemaContext(scope, new ReferenceRegistry(), vocabularies));
        }
        if (Types.isObject(document)) {
            Map<String, Object> object = Types.asObject(document);
            Vocabularies vocabularies = this.getVocabularies(schemaUri, version, object);
            return new JsonSchemaObject(object, new JsonSchemaContext(scope, result.getRegistry(), vocabularies));
        }
        throw new RuntimeException();
    }

    private @UnknownKeyFor @NonNull @Initialized Vocabularies getVocabularies(@UnknownKeyFor @NonNull @Initialized URI schemaUri, @UnknownKeyFor @NonNull @Initialized SchemaVersion version, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> document) {
        URI metaSchemaUri = this.getMetaSchemaUri(document);
        if (metaSchemaUri == null) {
            return Vocabularies.ALL;
        }
        SchemaVersion metaVersion = this.getMetaSchemaVersion(metaSchemaUri, version);
        Map<String, Object> metaObject = this.getDocument(metaSchemaUri);
        if (metaObject == null) {
            return Vocabularies.ALL;
        }
        return this.getVocabularies(metaObject, metaVersion);
    }

    private @Nullable @UnknownKeyFor @Initialized SchemaVersion getMetaSchemaVersion(@UnknownKeyFor @NonNull @Initialized URI schemaUri, @UnknownKeyFor @NonNull @Initialized SchemaVersion version) {
        SchemaVersion schemaVersion = SchemaVersion.getVersion(schemaUri);
        if (schemaVersion != null) {
            return schemaVersion;
        }
        Map<String, Object> document = this.getDocument(schemaUri);
        if (document == null) {
            return version;
        }
        URI metaSchemaUri = this.getMetaSchemaUri(document);
        if (metaSchemaUri == null) {
            return version;
        }
        SchemaVersion metaVersion = SchemaVersion.getVersion(metaSchemaUri);
        if (metaVersion != null) {
            return metaVersion;
        }
        return version;
    }

    private @Nullable @UnknownKeyFor @Initialized URI getMetaSchemaUri(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> schema) {
        Object schemaValue = schema.get(Keywords.SCHEMA);
        if (!Types.isString(schemaValue)) {
            return null;
        }
        return Uris.createUri(Types.asString(schemaValue));
    }

    private @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getDocument(@UnknownKeyFor @NonNull @Initialized URI schemaUri) {
        Object document = this.documents.get(schemaUri);
        if (document == null) {
            throw new RuntimeException();
        }
        if (!Types.isObject(document)) {
            return null;
        }
        return Types.asObject(document);
    }

    private @UnknownKeyFor @NonNull @Initialized Vocabularies getVocabularies(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> document, @UnknownKeyFor @NonNull @Initialized SchemaVersion version) {
        Object vocabularyValue = document.get(Keywords.VOCABULARY);
        if (!Types.isObject(vocabularyValue)) {
            return Vocabularies.ALL;
        }
        Map<String, Object> vocabularyObject = Types.asObject(vocabularyValue);
        LinkedHashMap<URI, Boolean> vocabularies = new LinkedHashMap<URI, Boolean>();
        vocabularyObject.forEach((propKey, propValue) -> vocabularies.put(Uris.createUri(propKey), Types.asBoolean(propValue)));
        return Vocabularies.create(vocabularies, version);
    }

    private @UnknownKeyFor @NonNull @Initialized URI generateUri() {
        return URI.create(String.format("https://%s/", UUID.randomUUID()));
    }

    public @UnknownKeyFor @NonNull @Initialized DocumentStore getDocuments() {
        return this.documents;
    }

    private static void warnDuplicateId(@UnknownKeyFor @NonNull @Initialized URI schemaUri) {
        log.warn("id is already registered: {}", (Object)schemaUri.toString());
    }
}

