/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.converter.TypeMismatchException;
import io.openapiprocessor.jsonschema.schema.InvalidPropertyException;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.support.Types;
import io.openapiprocessor.jsonschema.validator.support.Equals;
import java.util.Collection;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class JsonInstance {
    private final @Nullable @UnknownKeyFor @Initialized Object value;
    private final @UnknownKeyFor @NonNull @Initialized JsonPointer location;

    public JsonInstance(@Nullable @UnknownKeyFor @Initialized Object value) {
        this.value = value;
        this.location = JsonPointer.empty();
    }

    public JsonInstance(@UnknownKeyFor @NonNull @Initialized JsonPointer location, @Nullable @UnknownKeyFor @Initialized Object value) {
        this.value = value;
        this.location = location;
    }

    public @UnknownKeyFor @NonNull @Initialized JsonPointer getLocation() {
        return this.location;
    }

    public @UnknownKeyFor @NonNull @Initialized String getPath() {
        return this.location.toString();
    }

    public @Nullable @UnknownKeyFor @Initialized Object getRawValue() {
        return this.value;
    }

    public @UnknownKeyFor @NonNull @Initialized JsonInstance getPropertyName(@UnknownKeyFor @NonNull @Initialized String propertyName) {
        return new JsonInstance(this.location.append(propertyName), this.getPropertyKey(propertyName));
    }

    public @UnknownKeyFor @NonNull @Initialized JsonInstance getValue(@UnknownKeyFor @NonNull @Initialized String property) {
        return new JsonInstance(this.location.append(property), this.getPropertyValue(property));
    }

    public @UnknownKeyFor @NonNull @Initialized JsonInstance getValue(@UnknownKeyFor @NonNull @Initialized int idx) {
        return new JsonInstance(this.location.append(idx), this.getArrayValue(idx));
    }

    public @UnknownKeyFor @NonNull @Initialized int getArraySize() {
        return this.getArraySizeX();
    }

    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> asObject() {
        return Types.asMap(this.value);
    }

    public @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> asCollection() {
        return Types.asCol(this.value);
    }

    public @Nullable @UnknownKeyFor @Initialized String asString() {
        return Types.asString(this.value);
    }

    public @Nullable @UnknownKeyFor @Initialized Number asNumber() {
        return Types.asNumber(this.value);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isNull() {
        return this.value == null;
    }

    @EnsuresNonNullIf(expression={"value"}, result=true)
    public @UnknownKeyFor @NonNull @Initialized boolean isString() {
        return this.value instanceof String;
    }

    @EnsuresNonNullIf(expression={"value"}, result=true)
    public @UnknownKeyFor @NonNull @Initialized boolean isNumber() {
        return this.value instanceof Number;
    }

    @EnsuresNonNullIf(expression={"value"}, result=true)
    public @UnknownKeyFor @NonNull @Initialized boolean isObject() {
        return this.value instanceof Map;
    }

    @EnsuresNonNullIf(expression={"value"}, result=true)
    public @UnknownKeyFor @NonNull @Initialized boolean isArray() {
        return this.value instanceof Collection;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEqual(@UnknownKeyFor @NonNull @Initialized JsonInstance other) {
        return Equals.equals(this.value, other.value);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("%s", this.location != null ? this.location : "/");
    }

    private @Nullable @UnknownKeyFor @Initialized String getPropertyKey(@UnknownKeyFor @NonNull @Initialized String property) {
        if (this.value == null || !this.isObject()) {
            throw new TypeMismatchException(this.location.append(property), Map.class);
        }
        Map<String, Object> object = Types.asMap(this.value);
        if (!object.containsKey(property)) {
            throw new InvalidPropertyException(this.location.append(property));
        }
        return property;
    }

    private @Nullable @UnknownKeyFor @Initialized Object getPropertyValue(@UnknownKeyFor @NonNull @Initialized String property) {
        if (this.value == null || !this.isObject()) {
            throw new TypeMismatchException(this.location.append(property), Map.class);
        }
        Map<String, Object> object = Types.asMap(this.value);
        return object.get(property);
    }

    private @Nullable @UnknownKeyFor @Initialized Object getArrayValue(@UnknownKeyFor @NonNull @Initialized int idx) {
        if (this.value == null || !this.isArray()) {
            throw new TypeMismatchException(this.location, Collection.class);
        }
        Object[] items = Types.asCol(this.value).toArray();
        return items[idx];
    }

    private @UnknownKeyFor @NonNull @Initialized int getArraySizeX() {
        if (this.value == null || !this.isArray()) {
            throw new TypeMismatchException(this.location, Collection.class);
        }
        return Types.asCol(this.value).size();
    }
}

