/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.interfaces.Converter;
import io.openapiprocessor.interfaces.Reader;
import io.openapiprocessor.jsonschema.schema.DocumentLoaderException;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.support.Strings;
import java.io.InputStream;
import java.net.URI;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DocumentLoader {
    private final @UnknownKeyFor @NonNull @Initialized Reader reader;
    private final @UnknownKeyFor @NonNull @Initialized Converter converter;

    public DocumentLoader(@UnknownKeyFor @NonNull @Initialized Reader reader, @UnknownKeyFor @NonNull @Initialized Converter converter) {
        this.reader = reader;
        this.converter = converter;
    }

    public @UnknownKeyFor @NonNull @Initialized Object loadDocument(@UnknownKeyFor @NonNull @Initialized URI documentUri) {
        try {
            return this.converter.convert(Strings.of(this.reader.read(documentUri)));
        }
        catch (Exception e) {
            throw new DocumentLoaderException(String.format("failed to download '%s'.", documentUri), e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Object loadDocument(@UnknownKeyFor @NonNull @Initialized String resourcePath) {
        try {
            InputStream source = Null.nonNull(this.getClass().getResourceAsStream(resourcePath));
            return this.converter.convert(Strings.of(source));
        }
        catch (Exception e) {
            throw new DocumentLoaderException(String.format("failed to load '%s'.", resourcePath), e);
        }
    }
}

