/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.converter;

import io.openapiprocessor.jsonschema.converter.JsonSchemaConverter;
import io.openapiprocessor.jsonschema.converter.PropertyConverter;
import io.openapiprocessor.jsonschema.schema.JsonDependency;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.JsonSchemaContext;
import io.openapiprocessor.jsonschema.support.Null;
import io.openapiprocessor.jsonschema.support.Types;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MapDependencyConverter
implements PropertyConverter<Map<String, JsonDependency>> {
    private final @UnknownKeyFor @NonNull @Initialized JsonSchemaContext parentContext;

    public MapDependencyConverter(@UnknownKeyFor @NonNull @Initialized JsonSchemaContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonDependency> convert(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        Map<String, Object> objects = Types.convertMapOrNull(location, value);
        if (objects == null) {
            return null;
        }
        JsonPointer parentLocation = JsonPointer.from(location);
        LinkedHashMap result = new LinkedHashMap();
        objects.forEach((propKey, propValue) -> {
            if (Types.isObject(propValue) || Types.isBoolean(propValue)) {
                result.put(propKey, new JsonDependency(this.create(name, propValue, this.getLocation(parentLocation, (String)propKey))));
            } else if (Types.isArray(propValue)) {
                Collection<String> property = Types.asCol(propValue);
                result.put(propKey, new JsonDependency(property));
            }
        });
        return Collections.unmodifiableMap(result);
    }

    private @UnknownKeyFor @NonNull @Initialized JsonSchema create(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized String location) {
        return Null.nonNull(new JsonSchemaConverter(this.parentContext).convert(name, value, location));
    }

    private @UnknownKeyFor @NonNull @Initialized String getLocation(@UnknownKeyFor @NonNull @Initialized JsonPointer parent, @UnknownKeyFor @NonNull @Initialized String property) {
        return parent.getJsonPointer(property);
    }
}

