/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.string;

import io.openapiprocessor.jsonschema.schema.Format;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Nullness;
import io.openapiprocessor.jsonschema.validator.ValidatorSettings;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import io.openapiprocessor.jsonschema.validator.string.IpV4Step;
import io.openapiprocessor.jsonschema.validator.support.IpV4Validator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class IpV4 {
    private final @UnknownKeyFor @NonNull @Initialized ValidatorSettings settings;

    public IpV4(@UnknownKeyFor @NonNull @Initialized ValidatorSettings settings) {
        this.settings = settings;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        String format = schema.getFormat();
        if (!this.shouldValidate(format)) {
            return;
        }
        IpV4Step step = new IpV4Step(schema, instance);
        String instanceValue = this.getInstanceValue(instance);
        boolean valid = new IpV4Validator(instanceValue).validate();
        if (!valid) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean shouldValidate(@Nullable @UnknownKeyFor @Initialized String format) {
        return format != null && format.equals(Format.IPV4.getFormat()) && this.settings.validateFormat(Format.IPV4);
    }

    private @UnknownKeyFor @NonNull @Initialized String getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Nullness.nonNull(instance.asString());
    }
}

