/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.string;

import io.openapiprocessor.jsonschema.schema.Format;
import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Nullness;
import io.openapiprocessor.jsonschema.validator.ValidatorSettings;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import io.openapiprocessor.jsonschema.validator.string.DateTimeStep;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DateTime {
    private final @UnknownKeyFor @NonNull @Initialized ValidatorSettings settings;

    public DateTime(@UnknownKeyFor @NonNull @Initialized ValidatorSettings settings) {
        this.settings = settings;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        Format format = Format.of(schema.getFormat());
        if (!this.shouldValidate(format)) {
            return;
        }
        DateTimeStep step = new DateTimeStep(schema, instance);
        try {
            this.getParser(format).parse(this.getInstanceValue(instance));
        }
        catch (Exception ex) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    private @UnknownKeyFor @NonNull @Initialized boolean shouldValidate(@Nullable @UnknownKeyFor @Initialized Format format) {
        return format != null && this.settings.validateFormat(format) && (format.equals((Object)Format.DATE_TIME) || format.equals((Object)Format.DATE) || format.equals((Object)Format.TIME));
    }

    private @UnknownKeyFor @NonNull @Initialized String getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Nullness.nonNull(instance.asString());
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Parser<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getParser(@UnknownKeyFor @NonNull @Initialized Format format) {
        if (format.equals((Object)Format.DATE_TIME)) {
            return new DateTimeParser();
        }
        if (format.equals((Object)Format.DATE)) {
            return new DateParser();
        }
        if (format.equals((Object)Format.TIME)) {
            return new TimeParser();
        }
        throw new RuntimeException();
    }

    private static class TimeParser
    implements Parser<OffsetTime> {
        private TimeParser() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized OffsetTime parse(@UnknownKeyFor @NonNull @Initialized String value) {
            return DateTimeFormatter.ISO_OFFSET_TIME.parse((CharSequence)value, OffsetTime::from);
        }
    }

    private static class DateParser
    implements Parser<LocalDate> {
        private DateParser() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized LocalDate parse(@UnknownKeyFor @NonNull @Initialized String value) {
            return DateTimeFormatter.ISO_DATE.parse((CharSequence)value, LocalDate::from);
        }
    }

    private static class DateTimeParser
    implements Parser<OffsetDateTime> {
        private DateTimeParser() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized OffsetDateTime parse(@UnknownKeyFor @NonNull @Initialized String value) {
            return DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)value, OffsetDateTime::from);
        }
    }

    private static interface Parser<@UnknownKeyFor T> {
        public T parse(@UnknownKeyFor @NonNull @Initialized String var1);
    }
}

