/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.steps;

import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.JsonPointerSupport;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.schema.UriSupport;
import java.net.URI;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Step {
    public static @UnknownKeyFor @NonNull @Initialized URI getAbsoluteKeywordLocation(@UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        if (location.isEmpty()) {
            return scope.getBaseUri();
        }
        String encoded = "#/" + location.getTokens().stream().map(JsonPointerSupport::encode).map(UriSupport::encode).collect(Collectors.joining("/"));
        return UriSupport.resolve(scope.getBaseUri(), encoded);
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized JsonPointer schema, @UnknownKeyFor @NonNull @Initialized JsonPointer instance, @UnknownKeyFor @NonNull @Initialized boolean valid) {
        return String.format("%s (instance: %s), (schema: %s)", valid ? "valid" : "invalid", Step.toString(instance), Step.toString(schema));
    }

    private static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized JsonPointer pointer) {
        return pointer.isEmpty() ? "/" : pointer.toString();
    }
}

