/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.steps;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.validator.Annotation;
import io.openapiprocessor.jsonschema.validator.ValidationMessage;
import io.openapiprocessor.jsonschema.validator.steps.Step;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class SimpleStep
implements ValidationStep {
    protected final @UnknownKeyFor @NonNull @Initialized JsonSchema schema;
    protected final @UnknownKeyFor @NonNull @Initialized JsonInstance instance;
    protected final @UnknownKeyFor @NonNull @Initialized String property;
    private @UnknownKeyFor @NonNull @Initialized boolean valid = true;

    public SimpleStep(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized String property) {
        this.schema = schema;
        this.instance = instance;
        this.property = property;
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized ValidationMessage getError();

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ValidationStep> getSteps() {
        return Collections.emptyList();
    }

    @Override
    public void add(@UnknownKeyFor @NonNull @Initialized ValidationStep step) {
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized ValidationMessage getMessage() {
        return this.getError();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Annotation getAnnotation() {
        return null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Annotation> getAnnotations(@UnknownKeyFor @NonNull @Initialized String keyword) {
        return Collections.emptyList();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isValid() {
        return this.valid;
    }

    public void setInvalid() {
        this.valid = false;
    }

    public void setValid(@UnknownKeyFor @NonNull @Initialized boolean valid) {
        this.valid = valid;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getInstanceLocation() {
        return this.instance.getLocation();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getKeywordLocation() {
        return this.schema.getLocation().append(this.property);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized URI getAbsoluteKeywordLocation() {
        return Step.getAbsoluteKeywordLocation(this.getScope(), this.getKeywordLocation());
    }

    protected @UnknownKeyFor @NonNull @Initialized Scope getScope() {
        return this.schema.getContext().getScope();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return Step.toString(this.getKeywordLocation(), this.getInstanceLocation(), this.valid);
    }
}

