/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.steps;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.support.Nullness;
import io.openapiprocessor.jsonschema.validator.steps.CompositeStep;
import io.openapiprocessor.jsonschema.validator.steps.Step;
import java.net.URI;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class RefStep
extends CompositeStep {
    private final @UnknownKeyFor @NonNull @Initialized JsonSchema schema;
    protected final @UnknownKeyFor @NonNull @Initialized JsonInstance instance;

    public RefStep(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        this.schema = schema;
        this.instance = instance;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getInstanceLocation() {
        return this.instance.getLocation();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JsonPointer getKeywordLocation() {
        return this.schema.getLocation().append("$ref");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized URI getAbsoluteKeywordLocation() {
        return Step.getAbsoluteKeywordLocation(this.getScope(), this.getKeywordLocation());
    }

    public @UnknownKeyFor @NonNull @Initialized URI getRef() {
        return Nullness.nonNull(this.schema.getRef());
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return Step.toString(this.getKeywordLocation(), this.getInstanceLocation(), this.isValid());
    }

    private @UnknownKeyFor @NonNull @Initialized Scope getScope() {
        return this.schema.getContext().getScope();
    }
}

