/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.result;

import io.openapiprocessor.jsonschema.validator.ValidationMessage;
import io.openapiprocessor.jsonschema.validator.result.ResultTextBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FullResultTextBuilder
implements ResultTextBuilder {
    @Override
    public @UnknownKeyFor @NonNull @Initialized String getText(@UnknownKeyFor @NonNull @Initialized ValidationMessage message) {
        String location = this.trim(this.lastPartOfPath(message.getInstancePath()), 20);
        String instancePath = message.getInstancePath().length() != 0 ? this.trim(message.getInstancePath(), 40) : "/";
        String text = this.trim(message.getText(), 60);
        String schemaPath = message.getSchemaPath() != null ? message.getSchemaPath() : message.getSchemaScope();
        return String.format("%-20s: %-40s - %-60s   schema: %s", location, instancePath, text, schemaPath);
    }

    private @UnknownKeyFor @NonNull @Initialized String lastPartOfPath(@UnknownKeyFor @NonNull @Initialized String path) {
        int index = path.lastIndexOf("/");
        if (index == -1) {
            return path;
        }
        return path.substring(index);
    }

    private @UnknownKeyFor @NonNull @Initialized String trim(@UnknownKeyFor @NonNull @Initialized String source, @UnknownKeyFor @NonNull @Initialized int maxLength) {
        if (source.length() <= maxLength) {
            return source;
        }
        int trimmedStart = source.length() - (maxLength - 3);
        String trimmed = source.substring(trimmedStart);
        return ".. " + trimmed;
    }
}

