/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator.number.draft4;

import io.openapiprocessor.jsonschema.schema.JsonInstance;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.support.Nullness;
import io.openapiprocessor.jsonschema.validator.number.draft4.Minimum4Step;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.math.BigDecimal;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Minimum4 {
    public void validate(@UnknownKeyFor @NonNull @Initialized JsonSchema schema, @UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized ValidationStep parentStep) {
        boolean valid;
        Number minimum = schema.getMinimum();
        Boolean exclusive = schema.getExclusiveMinimumB();
        if (minimum == null) {
            return;
        }
        Minimum4Step step = new Minimum4Step(schema, instance);
        if (exclusive.booleanValue()) {
            valid = this.compareTo(instance, minimum) > 0;
        } else {
            boolean bl = valid = this.compareTo(instance, minimum) >= 0;
        }
        if (!valid) {
            step.setInvalid();
        }
        parentStep.add(step);
    }

    private @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized JsonInstance instance, @UnknownKeyFor @NonNull @Initialized Number minimum) {
        return new BigDecimal(this.getInstanceValue(instance).toString()).compareTo(new BigDecimal(minimum.toString()));
    }

    private @UnknownKeyFor @NonNull @Initialized Number getInstanceValue(@UnknownKeyFor @NonNull @Initialized JsonInstance instance) {
        return Nullness.nonNull(instance.asNumber());
    }
}

