/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.validator;

import io.openapiprocessor.jsonschema.validator.ValidationMessage;
import java.util.Collection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ValidationMessagePrinter {
    public @UnknownKeyFor @NonNull @Initialized String print(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ValidationMessage> messages) {
        ValidationMessage[] msgs = messages.toArray(new ValidationMessage[0]);
        StringBuilder builder = new StringBuilder();
        for (int idx = 0; idx < msgs.length; ++idx) {
            ValidationMessage msg = msgs[idx];
            builder.append(msg.getText()).append("\n");
            builder.append(this.print(msg.getNestedMessages(), ""));
        }
        return builder.toString();
    }

    private @UnknownKeyFor @NonNull @Initialized String print(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ValidationMessage> messages, @UnknownKeyFor @NonNull @Initialized String indent) {
        ValidationMessage[] nested = messages.toArray(new ValidationMessage[0]);
        StringBuilder builder = new StringBuilder();
        int lastIdx = nested.length - 1;
        for (int idx = 0; idx < nested.length; ++idx) {
            ValidationMessage msg = nested[idx];
            boolean currentLast = idx == lastIdx;
            String currentIndent = currentLast ? "\\--- " : "+--- ";
            String nestedIndent = indent + (currentLast ? "     " : "|    ");
            builder.append(indent).append(currentIndent).append(msg.getText()).append("\n");
            builder.append(this.print(msg.getNestedMessages(), nestedIndent));
        }
        return builder.toString();
    }
}

