/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.converter.Types;
import io.openapiprocessor.jsonschema.schema.DocumentLoader;
import io.openapiprocessor.jsonschema.schema.DocumentStore;
import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.JsonSchemaBoolean;
import io.openapiprocessor.jsonschema.schema.JsonSchemaContext;
import io.openapiprocessor.jsonschema.schema.JsonSchemaObject;
import io.openapiprocessor.jsonschema.schema.ReferenceRegistry;
import io.openapiprocessor.jsonschema.schema.Resolver;
import io.openapiprocessor.jsonschema.schema.ResolverResult;
import io.openapiprocessor.jsonschema.schema.SchemaResource;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.schema.UriSupport;
import io.openapiprocessor.jsonschema.schema.Vocabularies;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaStore {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(SchemaStore.class);
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized URI, @UnknownKeyFor @NonNull @Initialized JsonSchema> schemaCache = new HashMap<URI, JsonSchema>();
    private final @UnknownKeyFor @NonNull @Initialized DocumentStore documents = new DocumentStore();
    private final @UnknownKeyFor @NonNull @Initialized DocumentLoader loader;

    public SchemaStore(@UnknownKeyFor @NonNull @Initialized DocumentLoader loader) {
        this.loader = loader;
    }

    public void register(@UnknownKeyFor @NonNull @Initialized URI schemaUri) {
        if (this.documents.contains(schemaUri)) {
            log.warn("id is already registered: {}", (Object)schemaUri.toString());
            return;
        }
        Object document = this.loader.loadDocument(schemaUri);
        this.documents.addId(schemaUri, document);
    }

    public void register(@UnknownKeyFor @NonNull @Initialized URI schemaUri, @UnknownKeyFor @NonNull @Initialized Object document) {
        if (this.documents.contains(schemaUri)) {
            log.warn("id is already registered: {}", (Object)schemaUri.toString());
            return;
        }
        this.documents.addId(schemaUri, document);
    }

    public @UnknownKeyFor @NonNull @Initialized URI register(@UnknownKeyFor @NonNull @Initialized Object document) {
        URI schemaUri = this.generateUri();
        this.documents.addId(schemaUri, document);
        return schemaUri;
    }

    public void register(@UnknownKeyFor @NonNull @Initialized URI schemaUri, @UnknownKeyFor @NonNull @Initialized String resourcePath) {
        if (this.documents.contains(schemaUri)) {
            log.warn("id is already registered: {}", (Object)schemaUri.toString());
            return;
        }
        Object document = this.loader.loadDocument(resourcePath);
        this.documents.addId(schemaUri, document);
    }

    public void register(@UnknownKeyFor @NonNull @Initialized SchemaVersion version) {
        this.register(version.getSchemaResource());
        version.getVocabularyResources().forEach(this::register);
    }

    public void registerDraft202012() {
        this.register(SchemaVersion.Draft202012.getSchemaResource());
        SchemaVersion.Draft202012.getVocabularyResources().forEach(this::register);
    }

    public void registerDraft201909() {
        this.register(SchemaVersion.Draft201909.getSchemaResource());
        SchemaVersion.Draft201909.getVocabularyResources().forEach(this::register);
    }

    public void registerDraft7() {
        this.register(SchemaVersion.Draft7.getSchemaResource());
    }

    public void registerDraft6() {
        this.register(SchemaVersion.Draft6.getSchemaResource());
    }

    public void registerDraft4() {
        this.register(SchemaVersion.Draft4.getSchemaResource());
    }

    private void register(@UnknownKeyFor @NonNull @Initialized SchemaResource schema) {
        this.register(schema.getUri(), schema.getResource());
    }

    public @UnknownKeyFor @NonNull @Initialized JsonSchema getSchema(@UnknownKeyFor @NonNull @Initialized URI schemaUri) {
        return this.getSchema(schemaUri, SchemaVersion.getLatest());
    }

    public @UnknownKeyFor @NonNull @Initialized JsonSchema getSchema(@UnknownKeyFor @NonNull @Initialized URI schemaUri, @UnknownKeyFor @NonNull @Initialized SchemaVersion version) {
        JsonSchema schema = this.schemaCache.get(schemaUri);
        if (schema != null) {
            return schema;
        }
        Object document = this.documents.get(schemaUri);
        if (document == null) {
            throw new RuntimeException();
        }
        Resolver resolver = new Resolver(this.documents, this.loader, new Resolver.Settings(version));
        ResolverResult resolve = resolver.resolve(schemaUri, document);
        schema = this.createSchema(resolve);
        this.schemaCache.put(schemaUri, schema);
        return schema;
    }

    private @UnknownKeyFor @NonNull @Initialized JsonSchema createSchema(@UnknownKeyFor @NonNull @Initialized ResolverResult result) {
        Scope scope = result.getScope();
        Object document = result.getDocument();
        if (Types.isBoolean(document)) {
            Vocabularies vocabularies = Vocabularies.ALL;
            return new JsonSchemaBoolean(Types.asBoolean(document), new JsonSchemaContext(scope, new ReferenceRegistry(), vocabularies));
        }
        if (Types.isObject(document)) {
            URI metaSchema = this.getMetaSchema(document);
            Vocabularies vocabularies = this.getVocabularies(metaSchema);
            return new JsonSchemaObject(Types.asObject(document), new JsonSchemaContext(scope, result.getRegistry(), vocabularies));
        }
        throw new RuntimeException();
    }

    private @UnknownKeyFor @NonNull @Initialized Vocabularies getVocabularies(@Nullable @UnknownKeyFor @Initialized URI metaSchema) {
        if (metaSchema == null) {
            return Vocabularies.ALL;
        }
        SchemaVersion version = SchemaVersion.getVersion(metaSchema);
        if (version != null) {
            return Vocabularies.ALL;
        }
        JsonSchema metaSchemaSchema = this.getSchema(metaSchema);
        if (metaSchemaSchema == null) {
            throw new RuntimeException();
        }
        Vocabularies vocabulary = metaSchemaSchema.getVocabulary();
        if (vocabulary == null) {
            return Vocabularies.ALL;
        }
        return vocabulary;
    }

    private @Nullable @UnknownKeyFor @Initialized URI getMetaSchema(@UnknownKeyFor @NonNull @Initialized Object document) {
        if (!Types.isObject(document)) {
            return null;
        }
        Map<String, Object> object = Types.asObject(document);
        Object schema = object.get("$schema");
        if (!Types.isString(schema)) {
            return null;
        }
        return UriSupport.createUri(Types.asString(schema));
    }

    private @UnknownKeyFor @NonNull @Initialized URI generateUri() {
        return URI.create(String.format("https://%s/", UUID.randomUUID()));
    }

    public @UnknownKeyFor @NonNull @Initialized DocumentStore getDocuments() {
        return this.documents;
    }
}

