/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.converter.Types;
import io.openapiprocessor.jsonschema.schema.Bucket;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.Keyword;
import io.openapiprocessor.jsonschema.schema.RawValue;
import io.openapiprocessor.jsonschema.schema.Ref;
import io.openapiprocessor.jsonschema.schema.ResolverContext;
import io.openapiprocessor.jsonschema.schema.ResolverException;
import io.openapiprocessor.jsonschema.schema.ResolverId;
import io.openapiprocessor.jsonschema.schema.SchemaVersion;
import io.openapiprocessor.jsonschema.schema.Scope;
import java.net.URI;
import java.util.Collection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ResolverRef {
    private final @UnknownKeyFor @NonNull @Initialized ResolverContext context;

    public ResolverRef(@UnknownKeyFor @NonNull @Initialized ResolverContext context) {
        this.context = context;
    }

    public void resolve(@UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        this.context.addDocument(bucket.getScope(), bucket.getRawValues());
        this.walkBucket(bucket);
        this.resolve();
    }

    private void walkBucket(@UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        Scope scope = bucket.getScope();
        JsonPointer location = bucket.getLocation();
        SchemaVersion version = scope.getVersion();
        bucket.forEach((name, value) -> {
            boolean navigable;
            JsonPointer propLocation = location.append((String)name);
            Keyword keyword = version.getKeyword((String)name);
            boolean bl = navigable = keyword != null && keyword.isNavigable();
            if (name.equals("$schema") && Types.isString(value)) {
                Ref ref = this.createRef(scope, (String)name, value);
                this.walkRef(ref, propLocation);
            } else if (name.equals("$ref") && Types.isString(value)) {
                Ref ref = this.createRef(scope, (String)name, value);
                this.walkRef(ref, propLocation);
            } else if (name.equals("$dynamicRef") && Types.isString(value)) {
                Ref ref = this.createRef(scope, (String)name, value);
                this.walkRef(ref, propLocation);
            } else if (name.equals("$recursiveRef") && Types.isString(value)) {
                Ref ref = this.createRef(scope, (String)name, value);
                this.walkRef(ref, propLocation);
            } else if (navigable && keyword.isSchema() && Types.isObject(value)) {
                this.walkSchema(scope, value, propLocation);
            } else if (navigable && keyword.isSchemaArray() && Types.isArray(value)) {
                this.walkSchemaArray(scope, value, propLocation);
            } else if (navigable && keyword.isSchemaMap()) {
                this.walkSchemaMap(scope, value, propLocation);
            } else if (name.equals("default") && Types.isObject(value)) {
                this.walkSchema(scope, value, propLocation);
            } else if (keyword == null && Types.isObject(value)) {
                this.walkSchema(scope, value, propLocation);
            } else if (keyword == null && Types.isArray(value)) {
                this.walkSchemaArray(scope, value, propLocation);
            }
        });
    }

    private @UnknownKeyFor @NonNull @Initialized Ref createRef(@UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Object value) {
        String ref = Types.convertOrNull(name, value, String.class);
        if (ref == null) {
            throw new ResolverException(String.format("failed to resolve empty $ref in '%s'.", scope));
        }
        return new Ref(scope, ref);
    }

    private void walkRef(@UnknownKeyFor @NonNull @Initialized Ref ref, @UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        Scope scope = ref.getScope();
        URI uri = ref.getDocumentUri();
        Object document = this.context.getDocument(uri);
        if (document == null) {
            document = this.addDocument(scope, uri, ref);
        }
        if (!this.context.isProcessedDocument(uri)) {
            this.context.setProcessedDocument(uri);
            Scope docScope = scope.move(uri, document);
            Bucket bucket = Bucket.toBucket(docScope, document, JsonPointer.EMPTY);
            if (bucket == null) {
                return;
            }
            this.walkIds(bucket);
            this.walkBucket(bucket);
        }
        this.addReference(ref);
    }

    private void addReference(@UnknownKeyFor @NonNull @Initialized Ref ref) {
        this.context.addRef(ref);
    }

    private void walkIds(@UnknownKeyFor @NonNull @Initialized Bucket bucket) {
        ResolverId resolverId = new ResolverId(this.context);
        resolverId.resolve(bucket);
    }

    private void walkSchema(@UnknownKeyFor @NonNull @Initialized Scope currentScope, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        Scope scope = currentScope.move(value);
        Bucket bucket = Bucket.toBucket(scope, value, location);
        if (bucket == null) {
            return;
        }
        this.walkBucket(bucket);
    }

    private void walkSchemaArray(@UnknownKeyFor @NonNull @Initialized Scope currentScope, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        Collection items = Types.asArray(value);
        if (items == null) {
            return;
        }
        int index = 0;
        for (Object item : items) {
            JsonPointer itemLocation = location.append(index);
            this.walkSchema(currentScope, item, itemLocation);
            ++index;
        }
    }

    private void walkSchemaMap(@UnknownKeyFor @NonNull @Initialized Scope currentScope, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        Scope targetScope = currentScope.move(value);
        Bucket bucket = Bucket.toBucket(targetScope, value, location);
        if (bucket == null) {
            return;
        }
        bucket.forEach((propName, propValue) -> {
            JsonPointer propLocation = location.append((String)propName);
            this.walkSchema(targetScope, propValue, propLocation);
        });
    }

    private void resolve() {
        this.context.references.each(ref -> {
            URI id = ref.getAbsoluteUri();
            Object idDocument = this.context.getDocument(id);
            if (idDocument != null) {
                Scope docScope = ref.getScope().move(id, idDocument);
                this.context.addRef((Ref)ref, docScope, idDocument);
                return;
            }
            URI documentUri = ref.getDocumentUri();
            Object document = this.context.getDocument(documentUri);
            Scope scope = ref.getScope().move(documentUri, document);
            Bucket bucket = Bucket.toBucket(scope, document);
            if (bucket == null) {
                assert (document != null);
                this.context.addRef((Ref)ref, scope, document);
                return;
            }
            if (!ref.hasPointer()) {
                this.context.addRef((Ref)ref, scope, document);
                return;
            }
            RawValue referenced = bucket.getRawValue(JsonPointer.from(ref.getPointer()));
            if (referenced == null) {
                throw new ResolverException(String.format("failed to resolve ref <%s/%s>.", documentUri, ref));
            }
            this.context.addRef((Ref)ref, referenced.getScope(), referenced.getValue());
        });
    }

    private @Nullable @UnknownKeyFor @Initialized Object addDocument(@UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized Ref ref) {
        if (!ref.hasDocument()) {
            return null;
        }
        return this.context.addDocument(uri, scope.getDocumentUri().toString(), ref.getRef());
    }
}

