/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.schema.UriSupport;
import java.net.URI;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class Ref {
    public static final @UnknownKeyFor @NonNull @Initialized String START_OF_POINTER = "#/";
    private static final @UnknownKeyFor @NonNull @Initialized String EMPTY_REF = "";
    private static final @UnknownKeyFor @NonNull @Initialized URI EMPTY_REF_URI = URI.create("");
    private final @UnknownKeyFor @NonNull @Initialized Scope scope;
    private final @UnknownKeyFor @NonNull @Initialized String ref;
    private final @UnknownKeyFor @NonNull @Initialized URI refUri;

    public Ref(@UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized String ref) {
        this.scope = scope;
        this.ref = ref;
        this.refUri = UriSupport.createUri(ref);
    }

    public Ref(@UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized URI ref) {
        this.scope = scope;
        this.ref = ref.toString();
        this.refUri = ref;
    }

    public Ref(@UnknownKeyFor @NonNull @Initialized Scope scope) {
        this(scope, EMPTY_REF);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasPointer() {
        return this.ref.contains(START_OF_POINTER);
    }

    public @UnknownKeyFor @NonNull @Initialized String getPointer() {
        if (this.hasPointer()) {
            return this.ref.substring(this.ref.indexOf("#"));
        }
        return EMPTY_REF;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasDocument() {
        return this.ref.indexOf(START_OF_POINTER) != 0;
    }

    public @UnknownKeyFor @NonNull @Initialized URI getDocumentUri() {
        return UriSupport.stripFragment(this.getAbsoluteUri());
    }

    public @UnknownKeyFor @NonNull @Initialized Scope getScope() {
        return this.scope;
    }

    public @UnknownKeyFor @NonNull @Initialized URI getBaseUri() {
        return this.scope.getBaseUri();
    }

    public @UnknownKeyFor @NonNull @Initialized String getRef() {
        return this.ref;
    }

    public @UnknownKeyFor @NonNull @Initialized URI getRefUri() {
        return this.refUri;
    }

    public @UnknownKeyFor @NonNull @Initialized String getAbsoluteRef() {
        return this.getAbsoluteUri().toString();
    }

    public @UnknownKeyFor @NonNull @Initialized URI getAbsoluteUri() {
        if (this.ref.isEmpty()) {
            return this.scope.getBaseUri();
        }
        return UriSupport.resolve(this.scope.getBaseUri(), this.refUri);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.getAbsoluteUri().toString();
    }
}

