/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.JsonSchema;
import java.util.Collections;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JsonSchemas {
    private final @UnknownKeyFor @NonNull @Initialized Kind kind;
    private final @UnknownKeyFor @NonNull @Initialized int size;
    private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized JsonSchema> schemas;

    public JsonSchemas() {
        this.kind = Kind.EMPTY;
        this.schemas = Collections.emptyList();
        this.size = 0;
    }

    public JsonSchemas(@Nullable @UnknownKeyFor @Initialized JsonSchema schema) {
        if (schema == null) {
            this.kind = Kind.NULL;
            this.schemas = Collections.emptyList();
        } else {
            this.kind = Kind.SINGLE;
            this.schemas = Collections.singletonList(schema);
        }
        this.size = 1;
    }

    public JsonSchemas(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized JsonSchema> schemas) {
        this.kind = Kind.ARRAY;
        this.schemas = schemas;
        this.size = JsonSchemas.count(schemas);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.kind.equals((Object)Kind.EMPTY);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isNull() {
        return this.kind.equals((Object)Kind.NULL);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isSingle() {
        return this.kind.equals((Object)Kind.SINGLE);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isArray() {
        return this.kind.equals((Object)Kind.ARRAY);
    }

    public @UnknownKeyFor @NonNull @Initialized JsonSchema getSchema() {
        return this.schemas.iterator().next();
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized JsonSchema> getSchemas() {
        return this.schemas;
    }

    public @UnknownKeyFor @NonNull @Initialized int size() {
        return this.size;
    }

    private static @UnknownKeyFor @NonNull @Initialized int count(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized JsonSchema> schemas) {
        return (int)StreamSupport.stream(schemas.spliterator(), false).count();
    }

    private static enum Kind {
        EMPTY,
        NULL,
        SINGLE,
        ARRAY;

    }
}

