/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.schema.JsonSchema;
import io.openapiprocessor.jsonschema.schema.JsonSchemaContext;
import io.openapiprocessor.jsonschema.schema.UriSupport;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class DynamicScope {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Scope> scopes = new ArrayList<Scope>();

    public DynamicScope(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        this.scopes.add(new Scope(schema));
    }

    private DynamicScope(@UnknownKeyFor @NonNull @Initialized DynamicScope source) {
        this.scopes.addAll(source.scopes);
    }

    public @UnknownKeyFor @NonNull @Initialized DynamicScope add(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
        if (this.scopes.size() == 0) {
            return this;
        }
        Scope last = this.scopes.get(this.scopes.size() - 1);
        if (last.equal(schema)) {
            return this;
        }
        DynamicScope dynamicScope = new DynamicScope(this);
        Scope scope = new Scope(schema);
        dynamicScope.scopes.add(scope);
        return dynamicScope;
    }

    public @Nullable @UnknownKeyFor @Initialized URI findScope(@UnknownKeyFor @NonNull @Initialized URI dynamicRef) {
        Scope match = null;
        URI dynamicAnchor = dynamicRef.equals(UriSupport.emptyFragment()) ? dynamicRef : UriSupport.createUri("#" + dynamicRef.getFragment());
        boolean first = true;
        ListIterator<Scope> lit = this.scopes.listIterator(this.scopes.size());
        while (lit.hasPrevious()) {
            boolean hasDynamicAnchor;
            Scope previous = lit.previous();
            if (first) {
                first = false;
                hasDynamicAnchor = previous.matches(dynamicRef.toString());
                if (hasDynamicAnchor) {
                    match = previous;
                    continue;
                }
                return null;
            }
            hasDynamicAnchor = previous.matches(dynamicAnchor.toString());
            if (!hasDynamicAnchor) continue;
            match = previous;
        }
        if (match == null) {
            return null;
        }
        return match.getBaseUri();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("length %d", this.scopes.size());
    }

    private static class Scope {
        private final @UnknownKeyFor @NonNull @Initialized JsonSchema schema;

        Scope(@UnknownKeyFor @NonNull @Initialized JsonSchema schema) {
            this.schema = schema;
        }

        @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized String anchor) {
            JsonSchemaContext context = this.schema.getContext();
            return context.hasDynamicReference(anchor);
        }

        @UnknownKeyFor @NonNull @Initialized boolean equal(@UnknownKeyFor @NonNull @Initialized JsonSchema other) {
            return this.getBaseUri(this.schema).equals(this.getBaseUri(other));
        }

        @UnknownKeyFor @NonNull @Initialized URI getBaseUri() {
            return this.getBaseUri(this.schema);
        }

        @UnknownKeyFor @NonNull @Initialized URI getBaseUri(@UnknownKeyFor @NonNull @Initialized JsonSchema source) {
            return source.getContext().getScope().getBaseUri();
        }
    }
}

