/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.schema;

import io.openapiprocessor.jsonschema.converter.NoValueException;
import io.openapiprocessor.jsonschema.converter.PropertiesConverter;
import io.openapiprocessor.jsonschema.converter.PropertyConverter;
import io.openapiprocessor.jsonschema.converter.TypeMismatchException;
import io.openapiprocessor.jsonschema.converter.Types;
import io.openapiprocessor.jsonschema.schema.BucketVisitor;
import io.openapiprocessor.jsonschema.schema.JsonPointer;
import io.openapiprocessor.jsonschema.schema.RawValue;
import io.openapiprocessor.jsonschema.schema.Scope;
import io.openapiprocessor.jsonschema.schema.UriSupport;
import io.openapiprocessor.jsonschema.support.Nullness;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Bucket {
    private final @UnknownKeyFor @NonNull @Initialized Scope scope;
    private final @UnknownKeyFor @NonNull @Initialized JsonPointer location;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties;

    public static @UnknownKeyFor @NonNull @Initialized Bucket empty() {
        return new Bucket(Collections.emptyMap());
    }

    public static @Nullable @UnknownKeyFor @Initialized Bucket toBucket(@UnknownKeyFor @NonNull @Initialized Scope scope, @PolyNull @UnknownKeyFor @Initialized Object source) {
        if (!Types.isObject(source)) {
            return null;
        }
        return new Bucket(scope, Types.asObject(source));
    }

    public static @Nullable @UnknownKeyFor @Initialized Bucket toBucket(@UnknownKeyFor @NonNull @Initialized Scope scope, @Nullable @UnknownKeyFor @Initialized Object source, @UnknownKeyFor @NonNull @Initialized JsonPointer location) {
        if (!Types.isObject(source)) {
            return null;
        }
        return new Bucket(scope, location, Types.asObject(source));
    }

    @Deprecated
    public Bucket(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties) {
        this.scope = new Scope(URI.create(""), URI.create(""), null);
        this.location = JsonPointer.EMPTY;
        this.properties = properties;
    }

    @Deprecated
    public Bucket(@UnknownKeyFor @NonNull @Initialized URI source, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties) {
        this.scope = new Scope(source, URI.create(""), null);
        this.location = JsonPointer.EMPTY;
        this.properties = properties;
    }

    public Bucket(@UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties) {
        this.scope = scope;
        this.location = JsonPointer.EMPTY;
        this.properties = properties;
    }

    public Bucket(@UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized JsonPointer location, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties) {
        this.scope = scope;
        this.location = location;
        this.properties = properties;
    }

    @Deprecated
    public Bucket(@UnknownKeyFor @NonNull @Initialized URI source, @UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties) {
        this.scope = new Scope(source, URI.create(""), null);
        this.location = JsonPointer.from(location);
        this.properties = properties;
    }

    public Bucket(@UnknownKeyFor @NonNull @Initialized Scope scope, @UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties) {
        this.scope = scope;
        this.location = JsonPointer.from(location);
        this.properties = properties;
    }

    public @UnknownKeyFor @NonNull @Initialized Scope getScope() {
        return this.scope;
    }

    public @UnknownKeyFor @NonNull @Initialized URI getBaseUri() {
        return this.scope.getBaseUri();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasId() {
        return this.scope.getVersion().getIdProvider().getId(this.properties) != null;
    }

    public @Nullable @UnknownKeyFor @Initialized URI getId() {
        String id = this.scope.getVersion().getIdProvider().getId(this.properties);
        if (id == null) {
            return null;
        }
        return UriSupport.createUri(id);
    }

    public @UnknownKeyFor @NonNull @Initialized JsonPointer getLocation() {
        return this.location;
    }

    public <T> @Nullable T convert(@UnknownKeyFor @NonNull @Initialized String property, @UnknownKeyFor @NonNull @Initialized PropertyConverter<T> converter) {
        return converter.convert(property, this.getRawValue(property), this.getLocation(property));
    }

    public <T> @Nullable T convert(@UnknownKeyFor @NonNull @Initialized PropertiesConverter<T> converter) {
        return converter.convert(this.properties, this.location.toString());
    }

    public @Nullable @UnknownKeyFor @Initialized Bucket getBucket(@UnknownKeyFor @NonNull @Initialized String property) {
        Object value = this.getRawValue(property);
        if (value == null) {
            return null;
        }
        if (!Types.isMap(value)) {
            throw new TypeMismatchException(this.getLocation(property), Map.class);
        }
        return new Bucket(this.scope, this.getLocation(property), Types.asMap(value));
    }

    public @Nullable @UnknownKeyFor @Initialized Object getRawValue(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.properties.get(property);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getRawValues() {
        return this.properties;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasProperty(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.properties.containsKey(property);
    }

    public @Nullable @UnknownKeyFor @Initialized Object getProperty(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.properties.get(property);
    }

    public @Nullable @UnknownKeyFor @Initialized RawValue getRawValue(@UnknownKeyFor @NonNull @Initialized JsonPointer pointer) {
        JsonPointer current = JsonPointer.empty();
        Object value = this.properties;
        Scope scope = this.scope;
        for (String token : pointer.getTokens()) {
            current = current.append(token);
            if (value == this.properties) {
                Map<String, Object> self = Types.asObject(value);
                value = this.getObjectValue(self, current);
                continue;
            }
            if (Types.isObject(value)) {
                Map<String, Object> object = Types.asObject(value);
                value = this.getObjectValue(object, current);
                scope = scope.move(value);
                continue;
            }
            if (!Types.isArray(value)) continue;
            Collection<Object> array = Types.asCol(value);
            value = this.getArrayValue(array, current);
            scope = scope.move(value);
        }
        return new RawValue(scope, value);
    }

    public @Nullable @UnknownKeyFor @Initialized Object getRawValueValue(@UnknownKeyFor @NonNull @Initialized JsonPointer pointer) {
        RawValue value = this.getRawValue(pointer);
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    private @UnknownKeyFor @NonNull @Initialized Object getObjectValue(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> object, @UnknownKeyFor @NonNull @Initialized JsonPointer pointer) {
        Object value = object.get(pointer.tail());
        if (value == null) {
            throw new NoValueException(pointer.toString());
        }
        return value;
    }

    private @UnknownKeyFor @NonNull @Initialized Object getArrayValue(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> array, @UnknownKeyFor @NonNull @Initialized JsonPointer pointer) {
        Object value = array.toArray()[pointer.tailIndex()];
        if (value == null) {
            throw new NoValueException(pointer.toString());
        }
        return value;
    }

    @Deprecated
    public void walkPropertyTree(@UnknownKeyFor @NonNull @Initialized String property, @UnknownKeyFor @NonNull @Initialized BucketVisitor handler) {
        Object value = this.getRawValue(property);
        JsonPointer propertyLocation = this.location.append(property);
        if (Types.isObject(value)) {
            handler.visit(Nullness.nonNull(this.getBucket(property)));
        } else if (value instanceof Collection) {
            int index = 0;
            for (Object o : (Collection)value) {
                if (!(o instanceof Map)) continue;
                handler.visit(new Bucket(this.scope, propertyLocation.append(index).toString(), Types.asMap(o)));
                ++index;
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized String getLocation(@UnknownKeyFor @NonNull @Initialized String property) {
        return this.location.getJsonPointer(property);
    }

    public void forEach(@UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> action) {
        this.properties.forEach(action);
    }

    public void forEachProperty(@UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized String> action) {
        this.properties.keySet().forEach(action);
    }
}

