/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jsonschema.ouput;

import io.openapiprocessor.jsonschema.ouput.OutputUnit;
import io.openapiprocessor.jsonschema.ouput.OutputUnitFlag;
import io.openapiprocessor.jsonschema.ouput.OutputUnitNode;
import io.openapiprocessor.jsonschema.schema.Output;
import io.openapiprocessor.jsonschema.schema.UriSupport;
import io.openapiprocessor.jsonschema.validator.Annotation;
import io.openapiprocessor.jsonschema.validator.ValidationMessage;
import io.openapiprocessor.jsonschema.validator.steps.DynamicRefStep;
import io.openapiprocessor.jsonschema.validator.steps.RefStep;
import io.openapiprocessor.jsonschema.validator.steps.ValidationStep;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class OutputConverter {
    private final @UnknownKeyFor @NonNull @Initialized Output output;

    public OutputConverter(@UnknownKeyFor @NonNull @Initialized Output output) {
        this.output = output;
    }

    public @UnknownKeyFor @NonNull @Initialized OutputUnit convert(@UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        if (Output.FLAG.equals((Object)this.output)) {
            return this.flag(step);
        }
        if (Output.BASIC.equals((Object)this.output)) {
            return this.basic(step);
        }
        if (Output.VERBOSE.equals((Object)this.output)) {
            return this.verbose(step, null);
        }
        throw new RuntimeException();
    }

    private @UnknownKeyFor @NonNull @Initialized OutputUnit flag(@UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        return new OutputUnitFlag(step.isValid());
    }

    private @UnknownKeyFor @NonNull @Initialized OutputUnit basic(@UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        OutputUnit verbose = this.verbose(step, null);
        OutputUnitNode basic = new OutputUnitNode();
        basic.setValid(verbose.isValid());
        if (verbose.isValid()) {
            ArrayList<OutputUnit> annotations = new ArrayList<OutputUnit>();
            this.flattenBasicAnnotations(verbose, annotations);
            basic.setAnnotations(annotations);
        } else {
            ArrayList<OutputUnit> errors = new ArrayList<OutputUnit>();
            this.flattenBasicErrors(verbose, errors);
            basic.setErrors(errors);
        }
        return basic;
    }

    private void flattenBasicAnnotations(@UnknownKeyFor @NonNull @Initialized OutputUnit verbose, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized OutputUnit> result) {
        Collection<OutputUnit> annotations;
        Object currentAnnotation = verbose.getAnnotation();
        if (this.hasAnnotationValue(currentAnnotation)) {
            OutputUnitNode node = new OutputUnitNode();
            node.setValid(verbose.isValid());
            node.setKeywordLocation(verbose.getKeywordLocation());
            node.setInstanceLocation(verbose.getInstanceLocation());
            node.setAbsoluteKeywordLocation(verbose.getAbsoluteKeywordLocation());
            node.setAnnotation(verbose.getAnnotation());
            result.add(node);
        }
        if ((annotations = verbose.getAnnotations()) == null) {
            return;
        }
        for (OutputUnit annotation : annotations) {
            this.flattenBasicAnnotations(annotation, result);
        }
    }

    private void flattenBasicErrors(@UnknownKeyFor @NonNull @Initialized OutputUnit verbose, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized OutputUnit> result) {
        Collection<OutputUnit> errors;
        String currentError = verbose.getError();
        if (currentError != null) {
            OutputUnitNode node = new OutputUnitNode();
            node.setValid(verbose.isValid());
            node.setKeywordLocation(verbose.getKeywordLocation());
            node.setInstanceLocation(verbose.getInstanceLocation());
            node.setAbsoluteKeywordLocation(verbose.getAbsoluteKeywordLocation());
            node.setError(verbose.getError());
            result.add(node);
        }
        if ((errors = verbose.getErrors()) == null) {
            return;
        }
        for (OutputUnit error : errors) {
            this.flattenBasicErrors(error, result);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasAnnotationValue(@UnknownKeyFor @NonNull @Initialized Object annotation) {
        if (annotation == null) {
            return false;
        }
        return !(annotation instanceof Collection) || !((Collection)annotation).isEmpty();
    }

    private @UnknownKeyFor @NonNull @Initialized OutputUnit verbose(@UnknownKeyFor @NonNull @Initialized ValidationStep step, @Nullable @UnknownKeyFor @Initialized RefLocation parentRefLocation) {
        String fragment;
        URI ref;
        Object refStep;
        ArrayList<OutputUnit> annotations = new ArrayList<OutputUnit>();
        ArrayList<OutputUnit> errors = new ArrayList<OutputUnit>();
        RefLocation refLocation = parentRefLocation;
        if (step instanceof RefStep) {
            refStep = (RefStep)step;
            ref = ((RefStep)refStep).getRef();
            fragment = ref.getFragment();
            refLocation = new RefLocation(fragment, this.getKeywordLocation(step, refLocation));
        } else if (step instanceof DynamicRefStep) {
            refStep = (DynamicRefStep)step;
            ref = ((DynamicRefStep)refStep).getRef();
            fragment = ref.getFragment();
            refLocation = new RefLocation(fragment, this.getKeywordLocation(step, refLocation));
        }
        for (ValidationStep s : step.getSteps()) {
            if (s.isValid()) {
                annotations.add(this.verbose(s, refLocation));
                continue;
            }
            errors.add(this.verbose(s, refLocation));
        }
        OutputUnitNode verbose = new OutputUnitNode();
        verbose.setValid(step.isValid());
        verbose.setKeywordLocation(this.getKeywordLocation(step, refLocation));
        verbose.setInstanceLocation(step.getInstanceLocation().toString());
        verbose.setAbsoluteKeywordLocation(this.getAbsoluteKeywordLocation(step));
        verbose.setError(this.getError(step));
        verbose.setErrors(!errors.isEmpty() ? errors : null);
        verbose.setAnnotation(this.getAnnotation(step));
        verbose.setAnnotations(!annotations.isEmpty() ? annotations : null);
        return verbose;
    }

    private @Nullable @UnknownKeyFor @Initialized Object getAnnotation(@UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        Annotation annotation = step.getAnnotation();
        if (annotation == null) {
            return null;
        }
        return annotation.getValue();
    }

    private @UnknownKeyFor @NonNull @Initialized String getKeywordLocation(@UnknownKeyFor @NonNull @Initialized ValidationStep step, @Nullable @UnknownKeyFor @Initialized RefLocation refLocation) {
        Object location = step.getKeywordLocation().toString();
        if (refLocation == null) {
            return location;
        }
        String source = refLocation.getSource();
        if (source == null) {
            return location;
        }
        if (source.equals(location) || source.isEmpty()) {
            return location;
        }
        if (((String)location).startsWith(source)) {
            location = refLocation.getTarget() + ((String)location).substring(source.length());
        }
        return location;
    }

    private @UnknownKeyFor @NonNull @Initialized String getAbsoluteKeywordLocation(@UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        return UriSupport.decode(step.getAbsoluteKeywordLocation().toString());
    }

    private @Nullable @UnknownKeyFor @Initialized String getError(@UnknownKeyFor @NonNull @Initialized ValidationStep step) {
        ValidationMessage message = step.getMessage();
        if (step.isValid() || message == null) {
            return null;
        }
        return message.getText();
    }

    static class RefLocation {
        private final @Nullable @UnknownKeyFor @Initialized String source;
        private final @UnknownKeyFor @NonNull @Initialized String target;

        public RefLocation(@Nullable @UnknownKeyFor @Initialized String source, @UnknownKeyFor @NonNull @Initialized String target) {
            this.source = source;
            this.target = target;
        }

        public @Nullable @UnknownKeyFor @Initialized String getSource() {
            return this.source;
        }

        public @UnknownKeyFor @NonNull @Initialized String getTarget() {
            return this.target;
        }
    }
}

