/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.processor;

import io.objectbox.generator.model.PropertyType;
import io.objectbox.relation.ToMany;
import io.objectbox.relation.ToOne;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010#\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010%\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bJ\"\u0010'\u001a\u00020\b\"\u0004\b\u0000\u0010(*\b\u0012\u0004\u0012\u0002H(0)2\b\b\u0002\u0010*\u001a\u00020\u001bH\u0002J \u0010+\u001a\u00020\u001b*\u00020\b2\u0006\u0010,\u001a\u00020\b2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\bH\u0002J\u001e\u0010.\u001a\u00020\u001b*\u00020\b2\u0006\u0010/\u001a\u00020\b2\b\b\u0002\u0010*\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/objectbox/processor/TypeHelper;", "", "elementUtils", "Ljavax/lang/model/util/Elements;", "typeUtils", "Ljavax/lang/model/util/Types;", "(Ljavax/lang/model/util/Elements;Ljavax/lang/model/util/Types;)V", "typeBoolean", "Ljavax/lang/model/type/TypeMirror;", "typeByte", "typeCharacter", "typeDate", "typeDouble", "typeFloat", "typeInteger", "typeList", "typeLong", "typeMap", "typeObject", "typeShort", "typeString", "typeToMany", "typeToOne", "getPropertyType", "Lio/objectbox/generator/model/PropertyType;", "typeMirror", "isIntegerLongMap", "", "isIntegerMap", "isList", "isLongLongMap", "isLongMap", "isObject", "isStringList", "isStringLongMap", "isStringMap", "isStringStringMap", "isToMany", "isToOne", "getTypeMirror", "T", "Ljava/lang/Class;", "eraseTypeParameters", "isMapOf", "expectedKeyType", "expectedValueType", "isSameTypeAs", "otherType", "objectbox-processor"})
public final class TypeHelper {
    @NotNull
    private final Elements elementUtils;
    @NotNull
    private final Types typeUtils;
    @NotNull
    private final TypeMirror typeShort;
    @NotNull
    private final TypeMirror typeInteger;
    @NotNull
    private final TypeMirror typeLong;
    @NotNull
    private final TypeMirror typeFloat;
    @NotNull
    private final TypeMirror typeDouble;
    @NotNull
    private final TypeMirror typeBoolean;
    @NotNull
    private final TypeMirror typeByte;
    @NotNull
    private final TypeMirror typeDate;
    @NotNull
    private final TypeMirror typeCharacter;
    @NotNull
    private final TypeMirror typeString;
    @NotNull
    private final TypeMirror typeObject;
    @NotNull
    private final TypeMirror typeMap;
    @NotNull
    private final TypeMirror typeToOne;
    @NotNull
    private final TypeMirror typeToMany;
    @NotNull
    private final TypeMirror typeList;

    public TypeHelper(@NotNull Elements elementUtils, @NotNull Types typeUtils) {
        Intrinsics.checkNotNullParameter((Object)elementUtils, (String)"elementUtils");
        Intrinsics.checkNotNullParameter((Object)typeUtils, (String)"typeUtils");
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.typeShort = TypeHelper.getTypeMirror$default(this, Short.class, false, 1, null);
        this.typeInteger = TypeHelper.getTypeMirror$default(this, Integer.class, false, 1, null);
        this.typeLong = TypeHelper.getTypeMirror$default(this, Long.class, false, 1, null);
        this.typeFloat = TypeHelper.getTypeMirror$default(this, Float.class, false, 1, null);
        this.typeDouble = TypeHelper.getTypeMirror$default(this, Double.class, false, 1, null);
        this.typeBoolean = TypeHelper.getTypeMirror$default(this, Boolean.class, false, 1, null);
        this.typeByte = TypeHelper.getTypeMirror$default(this, Byte.class, false, 1, null);
        this.typeDate = TypeHelper.getTypeMirror$default(this, Date.class, false, 1, null);
        this.typeCharacter = TypeHelper.getTypeMirror$default(this, Character.class, false, 1, null);
        this.typeString = TypeHelper.getTypeMirror$default(this, String.class, false, 1, null);
        this.typeObject = TypeHelper.getTypeMirror$default(this, Object.class, false, 1, null);
        this.typeMap = this.getTypeMirror(Map.class, true);
        this.typeToOne = this.getTypeMirror(ToOne.class, true);
        this.typeToMany = this.getTypeMirror(ToMany.class, true);
        this.typeList = this.getTypeMirror(List.class, true);
    }

    private final boolean isSameTypeAs(TypeMirror $this$isSameTypeAs, TypeMirror otherType, boolean eraseTypeParameters) {
        return this.typeUtils.isSameType(eraseTypeParameters ? this.typeUtils.erasure($this$isSameTypeAs) : $this$isSameTypeAs, otherType);
    }

    static /* synthetic */ boolean isSameTypeAs$default(TypeHelper typeHelper, TypeMirror typeMirror, TypeMirror typeMirror2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return typeHelper.isSameTypeAs(typeMirror, typeMirror2, bl);
    }

    public final boolean isToOne(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        return this.isSameTypeAs(typeMirror, this.typeToOne, true);
    }

    public final boolean isToMany(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        return this.isSameTypeAs(typeMirror, this.typeToMany, true);
    }

    public final boolean isList(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        return this.isSameTypeAs(typeMirror, this.typeList, true);
    }

    public final boolean isStringList(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        if (!this.isList(typeMirror)) {
            return false;
        }
        List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
        if (typeArguments.size() != 1) {
            return false;
        }
        TypeMirror typeMirror2 = typeArguments.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror2, (String)"typeArguments[0]");
        return TypeHelper.isSameTypeAs$default(this, typeMirror2, this.typeString, false, 2, null);
    }

    private final boolean isMapOf(TypeMirror $this$isMapOf, TypeMirror expectedKeyType, TypeMirror expectedValueType) {
        if (!this.isSameTypeAs($this$isMapOf, this.typeMap, true)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)$this$isMapOf, (String)"null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
        List<? extends TypeMirror> typeArguments = ((DeclaredType)$this$isMapOf).getTypeArguments();
        if (typeArguments.size() != 2) {
            return false;
        }
        TypeMirror typeMirror = typeArguments.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"typeArguments[0]");
        boolean keyTypeMatches = TypeHelper.isSameTypeAs$default(this, typeMirror, expectedKeyType, false, 2, null);
        if (!keyTypeMatches || expectedValueType == null) {
            return keyTypeMatches;
        }
        TypeMirror typeMirror2 = typeArguments.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror2, (String)"typeArguments[1]");
        return TypeHelper.isSameTypeAs$default(this, typeMirror2, expectedValueType, false, 2, null);
    }

    static /* synthetic */ boolean isMapOf$default(TypeHelper typeHelper, TypeMirror typeMirror, TypeMirror typeMirror2, TypeMirror typeMirror3, int n, Object object) {
        if ((n & 2) != 0) {
            typeMirror3 = null;
        }
        return typeHelper.isMapOf(typeMirror, typeMirror2, typeMirror3);
    }

    public final boolean isStringMap(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        return TypeHelper.isMapOf$default(this, typeMirror, this.typeString, null, 2, null);
    }

    public final boolean isStringLongMap(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        return this.isMapOf(typeMirror, this.typeString, this.typeLong);
    }

    public final boolean isStringStringMap(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        return this.isMapOf(typeMirror, this.typeString, this.typeString);
    }

    public final boolean isIntegerMap(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        return TypeHelper.isMapOf$default(this, typeMirror, this.typeInteger, null, 2, null);
    }

    public final boolean isIntegerLongMap(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        return this.isMapOf(typeMirror, this.typeInteger, this.typeLong);
    }

    public final boolean isLongMap(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        return TypeHelper.isMapOf$default(this, typeMirror, this.typeLong, null, 2, null);
    }

    public final boolean isLongLongMap(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        return this.isMapOf(typeMirror, this.typeLong, this.typeLong);
    }

    public final boolean isObject(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        return TypeHelper.isSameTypeAs$default(this, typeMirror, this.typeObject, false, 2, null);
    }

    @Nullable
    public final PropertyType getPropertyType(@Nullable TypeMirror typeMirror) {
        if (typeMirror == null) {
            return null;
        }
        TypeKind kind = typeMirror.getKind();
        if (TypeHelper.isSameTypeAs$default(this, typeMirror, this.typeShort, false, 2, null) || kind == TypeKind.SHORT) {
            return PropertyType.Short;
        }
        if (TypeHelper.isSameTypeAs$default(this, typeMirror, this.typeInteger, false, 2, null) || kind == TypeKind.INT) {
            return PropertyType.Int;
        }
        if (TypeHelper.isSameTypeAs$default(this, typeMirror, this.typeLong, false, 2, null) || kind == TypeKind.LONG) {
            return PropertyType.Long;
        }
        if (TypeHelper.isSameTypeAs$default(this, typeMirror, this.typeFloat, false, 2, null) || kind == TypeKind.FLOAT) {
            return PropertyType.Float;
        }
        if (TypeHelper.isSameTypeAs$default(this, typeMirror, this.typeDouble, false, 2, null) || kind == TypeKind.DOUBLE) {
            return PropertyType.Double;
        }
        if (TypeHelper.isSameTypeAs$default(this, typeMirror, this.typeBoolean, false, 2, null) || kind == TypeKind.BOOLEAN) {
            return PropertyType.Boolean;
        }
        if (TypeHelper.isSameTypeAs$default(this, typeMirror, this.typeByte, false, 2, null) || kind == TypeKind.BYTE) {
            return PropertyType.Byte;
        }
        if (TypeHelper.isSameTypeAs$default(this, typeMirror, this.typeDate, false, 2, null)) {
            return PropertyType.Date;
        }
        if (TypeHelper.isSameTypeAs$default(this, typeMirror, this.typeCharacter, false, 2, null) || kind == TypeKind.CHAR) {
            return PropertyType.Char;
        }
        if (TypeHelper.isSameTypeAs$default(this, typeMirror, this.typeString, false, 2, null)) {
            return PropertyType.String;
        }
        if (kind == TypeKind.ARRAY) {
            TypeMirror arrayComponentType = ((ArrayType)typeMirror).getComponentType();
            if (arrayComponentType.getKind() == TypeKind.BYTE) {
                return PropertyType.ByteArray;
            }
            if (arrayComponentType.getKind() == TypeKind.SHORT) {
                return PropertyType.ShortArray;
            }
            if (arrayComponentType.getKind() == TypeKind.CHAR) {
                return PropertyType.CharArray;
            }
            if (arrayComponentType.getKind() == TypeKind.INT) {
                return PropertyType.IntArray;
            }
            if (arrayComponentType.getKind() == TypeKind.LONG) {
                return PropertyType.LongArray;
            }
            if (arrayComponentType.getKind() == TypeKind.FLOAT) {
                return PropertyType.FloatArray;
            }
            if (arrayComponentType.getKind() == TypeKind.DOUBLE) {
                return PropertyType.DoubleArray;
            }
            Intrinsics.checkNotNullExpressionValue((Object)arrayComponentType, (String)"arrayComponentType");
            if (TypeHelper.isSameTypeAs$default(this, arrayComponentType, this.typeString, false, 2, null)) {
                return PropertyType.StringArray;
            }
        }
        if (this.isStringList(typeMirror)) {
            return PropertyType.StringArray;
        }
        return null;
    }

    private final <T> TypeMirror getTypeMirror(Class<T> $this$getTypeMirror, boolean eraseTypeParameters) {
        TypeMirror typeMirror;
        TypeElement typeElement = this.elementUtils.getTypeElement($this$getTypeMirror.getCanonicalName());
        Intrinsics.checkNotNull((Object)typeElement);
        TypeMirror type = typeElement.asType();
        if (eraseTypeParameters) {
            TypeMirror typeMirror2 = this.typeUtils.erasure(type);
            typeMirror = typeMirror2;
            Intrinsics.checkNotNullExpressionValue((Object)typeMirror2, (String)"{\n            typeUtils.erasure(type)\n        }");
        } else {
            TypeMirror typeMirror3 = type;
            typeMirror = typeMirror3;
            Intrinsics.checkNotNullExpressionValue((Object)typeMirror3, (String)"{\n            type\n        }");
        }
        return typeMirror;
    }

    static /* synthetic */ TypeMirror getTypeMirror$default(TypeHelper typeHelper, Class clazz, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return typeHelper.getTypeMirror(clazz, bl);
    }
}

