/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.processor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"findProjectRoot", "Ljava/io/File;", "filer", "Ljavax/annotation/processing/Filer;", "objectbox-processor"})
public final class FileHelperKt {
    @NotNull
    public static final File findProjectRoot(@NotNull Filer filer) throws FileNotFoundException {
        File file;
        File buildFolder;
        Intrinsics.checkNotNullParameter((Object)filer, (String)"filer");
        FileObject fileProbe = null;
        try {
            FileObject fileObject = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "objectbox-probe" + System.currentTimeMillis(), new Element[0]);
            Intrinsics.checkNotNullExpressionValue((Object)fileObject, (String)"filer.createResource(Sta\u2026stem.currentTimeMillis())");
            fileProbe = fileObject;
        }
        catch (IOException e) {
            throw new FileNotFoundException("probe failed: " + e.getMessage());
        }
        String string = fileProbe.toUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileProbe.toUri().toString()");
        String filePathProbe = string;
        if (StringsKt.startsWith$default((String)filePathProbe, (String)"mem://", (boolean)false, (int)2, null) && (buildFolder = new File("build").getAbsoluteFile()).isDirectory()) {
            File file2 = buildFolder.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"buildFolder.parentFile");
            return file2;
        }
        if (StringsKt.startsWith$default((String)filePathProbe, (String)"file:", (boolean)false, (int)2, null)) {
            if (!StringsKt.startsWith$default((String)filePathProbe, (String)"file://", (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append("file://");
                String string2 = filePathProbe.substring(5);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                filePathProbe = stringBuilder.append(string2).toString();
            }
        } else {
            filePathProbe = "file://" + filePathProbe;
        }
        URI cleanURI = null;
        try {
            cleanURI = new URI(filePathProbe);
        }
        catch (URISyntaxException e) {
            throw new FileNotFoundException("parse failed: " + e.getMessage());
        }
        File dir = new File(cleanURI);
        File buildDir = null;
        File buildDirWithoutConfigFile = null;
        for (int i = 1; i < 10 && dir.getParentFile() != null; ++i) {
            if (new File(dir, "objectbox-build-config.json").exists()) {
                buildDir = dir;
                break;
            }
            if (!Intrinsics.areEqual((Object)dir.getName(), (Object)"build") || buildDirWithoutConfigFile != null) continue;
            buildDirWithoutConfigFile = dir;
        }
        if ((file = buildDir) == null || (file = file.getParentFile()) == null) {
            File file3 = buildDirWithoutConfigFile;
            file = file3 != null ? file3.getParentFile() : null;
            if (file == null) {
                throw new FileNotFoundException("Could not determine build folder from " + filePathProbe);
            }
        }
        return file;
    }
}

