/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.query;

import io.objectbox.Property;
import io.objectbox.query.PropertyQueryCondition;
import io.objectbox.query.QueryBuilder;
import io.objectbox.query.QueryCondition;
import io.objectbox.query.QueryConditionImpl;
import java.util.Date;

public abstract class PropertyQueryConditionImpl<T>
extends QueryConditionImpl<T>
implements PropertyQueryCondition<T> {
    public final Property<T> property;
    private String alias;

    PropertyQueryConditionImpl(Property<T> property) {
        this.property = property;
    }

    @Override
    public QueryCondition<T> alias(String name) {
        this.alias = name;
        return this;
    }

    @Override
    public void apply(QueryBuilder<T> builder) {
        this.applyCondition(builder);
        if (this.alias != null && this.alias.length() != 0) {
            builder.parameterAlias(this.alias);
        }
    }

    abstract void applyCondition(QueryBuilder<T> var1);

    public static class NearestNeighborCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final float[] queryVector;
        private final int maxResultCount;

        public NearestNeighborCondition(Property<T> property, float[] queryVector, int maxResultCount) {
            super(property);
            this.queryVector = queryVector;
            this.maxResultCount = maxResultCount;
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            builder.nearestNeighbors(this.property, this.queryVector, this.maxResultCount);
        }
    }

    public static class ByteArrayCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final Operation op;
        private final byte[] value;

        public ByteArrayCondition(Property<T> property, Operation op, byte[] value) {
            super(property);
            this.op = op;
            this.value = value;
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            switch (this.op.ordinal()) {
                case 0: {
                    builder.equal(this.property, this.value);
                    break;
                }
                case 1: {
                    builder.greater(this.property, this.value);
                    break;
                }
                case 2: {
                    builder.greaterOrEqual(this.property, this.value);
                    break;
                }
                case 3: {
                    builder.less(this.property, this.value);
                    break;
                }
                case 4: {
                    builder.lessOrEqual(this.property, this.value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)this.op) + " is not supported for byte[]");
                }
            }
        }

        public static enum Operation {
            EQUAL,
            GREATER,
            GREATER_OR_EQUAL,
            LESS,
            LESS_OR_EQUAL;

        }
    }

    public static class StringArrayCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final Operation op;
        private final String[] value;
        private final QueryBuilder.StringOrder order;

        public StringArrayCondition(Property<T> property, Operation op, String[] value, QueryBuilder.StringOrder order) {
            super(property);
            this.op = op;
            this.value = value;
            this.order = order;
        }

        public StringArrayCondition(Property<T> property, Operation op, String[] value) {
            this(property, op, value, QueryBuilder.StringOrder.CASE_SENSITIVE);
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            if (this.op != Operation.IN) {
                throw new UnsupportedOperationException((Object)((Object)this.op) + " is not supported for String[]");
            }
            builder.in(this.property, this.value, this.order);
        }

        public static enum Operation {
            IN;

        }
    }

    public static class StringDoubleCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final Operation op;
        private final String leftValue;
        private final double rightValue;

        public StringDoubleCondition(Property<T> property, Operation op, String leftValue, double rightValue) {
            super(property);
            this.op = op;
            this.leftValue = leftValue;
            this.rightValue = rightValue;
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            if (this.op == Operation.EQUAL_KEY_VALUE) {
                builder.equalKeyValue(this.property, this.leftValue, this.rightValue);
            } else if (this.op == Operation.GREATER_KEY_VALUE) {
                builder.greaterKeyValue(this.property, this.leftValue, this.rightValue);
            } else if (this.op == Operation.GREATER_EQUALS_KEY_VALUE) {
                builder.greaterOrEqualKeyValue(this.property, this.leftValue, this.rightValue);
            } else if (this.op == Operation.LESS_KEY_VALUE) {
                builder.lessKeyValue(this.property, this.leftValue, this.rightValue);
            } else if (this.op == Operation.LESS_EQUALS_KEY_VALUE) {
                builder.lessOrEqualKeyValue(this.property, this.leftValue, this.rightValue);
            } else {
                throw new UnsupportedOperationException((Object)((Object)this.op) + " is not supported with two String values");
            }
        }

        public static enum Operation {
            EQUAL_KEY_VALUE,
            GREATER_KEY_VALUE,
            GREATER_EQUALS_KEY_VALUE,
            LESS_KEY_VALUE,
            LESS_EQUALS_KEY_VALUE;

        }
    }

    public static class StringLongCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final Operation op;
        private final String leftValue;
        private final long rightValue;

        public StringLongCondition(Property<T> property, Operation op, String leftValue, long rightValue) {
            super(property);
            this.op = op;
            this.leftValue = leftValue;
            this.rightValue = rightValue;
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            if (this.op == Operation.EQUAL_KEY_VALUE) {
                builder.equalKeyValue(this.property, this.leftValue, this.rightValue);
            } else if (this.op == Operation.GREATER_KEY_VALUE) {
                builder.greaterKeyValue(this.property, this.leftValue, this.rightValue);
            } else if (this.op == Operation.GREATER_EQUALS_KEY_VALUE) {
                builder.greaterOrEqualKeyValue(this.property, this.leftValue, this.rightValue);
            } else if (this.op == Operation.LESS_KEY_VALUE) {
                builder.lessKeyValue(this.property, this.leftValue, this.rightValue);
            } else if (this.op == Operation.LESS_EQUALS_KEY_VALUE) {
                builder.lessOrEqualKeyValue(this.property, this.leftValue, this.rightValue);
            } else {
                throw new UnsupportedOperationException((Object)((Object)this.op) + " is not supported with two String values");
            }
        }

        public static enum Operation {
            EQUAL_KEY_VALUE,
            GREATER_KEY_VALUE,
            GREATER_EQUALS_KEY_VALUE,
            LESS_KEY_VALUE,
            LESS_EQUALS_KEY_VALUE;

        }
    }

    public static class StringStringCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final Operation op;
        private final String leftValue;
        private final String rightValue;
        private final QueryBuilder.StringOrder order;

        public StringStringCondition(Property<T> property, Operation op, String leftValue, String rightValue, QueryBuilder.StringOrder order) {
            super(property);
            this.op = op;
            this.leftValue = leftValue;
            this.rightValue = rightValue;
            this.order = order;
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            if (this.op == Operation.EQUAL_KEY_VALUE) {
                builder.equalKeyValue(this.property, this.leftValue, this.rightValue, this.order);
            } else if (this.op == Operation.GREATER_KEY_VALUE) {
                builder.greaterKeyValue(this.property, this.leftValue, this.rightValue, this.order);
            } else if (this.op == Operation.GREATER_EQUALS_KEY_VALUE) {
                builder.greaterOrEqualKeyValue(this.property, this.leftValue, this.rightValue, this.order);
            } else if (this.op == Operation.LESS_KEY_VALUE) {
                builder.lessKeyValue(this.property, this.leftValue, this.rightValue, this.order);
            } else if (this.op == Operation.LESS_EQUALS_KEY_VALUE) {
                builder.lessOrEqualKeyValue(this.property, this.leftValue, this.rightValue, this.order);
            } else {
                throw new UnsupportedOperationException((Object)((Object)this.op) + " is not supported with two String values");
            }
        }

        public static enum Operation {
            EQUAL_KEY_VALUE,
            GREATER_KEY_VALUE,
            GREATER_EQUALS_KEY_VALUE,
            LESS_KEY_VALUE,
            LESS_EQUALS_KEY_VALUE;

        }
    }

    public static class StringCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final Operation op;
        private final String value;
        private final QueryBuilder.StringOrder order;

        public StringCondition(Property<T> property, Operation op, String value, QueryBuilder.StringOrder order) {
            super(property);
            this.op = op;
            this.value = value;
            this.order = order;
        }

        public StringCondition(Property<T> property, Operation op, String value) {
            this(property, op, value, QueryBuilder.StringOrder.CASE_SENSITIVE);
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            switch (this.op.ordinal()) {
                case 0: {
                    builder.equal(this.property, this.value, this.order);
                    break;
                }
                case 1: {
                    builder.notEqual(this.property, this.value, this.order);
                    break;
                }
                case 2: {
                    builder.greater(this.property, this.value, this.order);
                    break;
                }
                case 3: {
                    builder.greaterOrEqual(this.property, this.value, this.order);
                    break;
                }
                case 4: {
                    builder.less(this.property, this.value, this.order);
                    break;
                }
                case 5: {
                    builder.lessOrEqual(this.property, this.value, this.order);
                    break;
                }
                case 6: {
                    builder.contains(this.property, this.value, this.order);
                    break;
                }
                case 7: {
                    builder.containsElement(this.property, this.value, this.order);
                    break;
                }
                case 8: {
                    builder.startsWith(this.property, this.value, this.order);
                    break;
                }
                case 9: {
                    builder.endsWith(this.property, this.value, this.order);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)this.op) + " is not supported for String");
                }
            }
        }

        public static enum Operation {
            EQUAL,
            NOT_EQUAL,
            GREATER,
            GREATER_OR_EQUAL,
            LESS,
            LESS_OR_EQUAL,
            CONTAINS,
            CONTAINS_ELEMENT,
            STARTS_WITH,
            ENDS_WITH;

        }
    }

    public static class DoubleDoubleCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final Operation op;
        private final double leftValue;
        private final double rightValue;

        public DoubleDoubleCondition(Property<T> property, Operation op, double leftValue, double rightValue) {
            super(property);
            this.op = op;
            this.leftValue = leftValue;
            this.rightValue = rightValue;
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            if (this.op != Operation.BETWEEN) {
                throw new UnsupportedOperationException((Object)((Object)this.op) + " is not supported with two double values");
            }
            builder.between(this.property, this.leftValue, this.rightValue);
        }

        public static enum Operation {
            BETWEEN;

        }
    }

    public static class DoubleCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final Operation op;
        private final double value;

        public DoubleCondition(Property<T> property, Operation op, double value) {
            super(property);
            this.op = op;
            this.value = value;
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            switch (this.op.ordinal()) {
                case 0: {
                    builder.greater(this.property, this.value);
                    break;
                }
                case 1: {
                    builder.greaterOrEqual(this.property, this.value);
                    break;
                }
                case 2: {
                    builder.less(this.property, this.value);
                    break;
                }
                case 3: {
                    builder.lessOrEqual(this.property, this.value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)this.op) + " is not supported for double");
                }
            }
        }

        public static enum Operation {
            GREATER,
            GREATER_OR_EQUAL,
            LESS,
            LESS_OR_EQUAL;

        }
    }

    public static class LongArrayCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final Operation op;
        private final long[] value;

        public LongArrayCondition(Property<T> property, Operation op, long[] value) {
            super(property);
            this.op = op;
            this.value = value;
        }

        public LongArrayCondition(Property<T> property, Operation op, Date[] value) {
            super(property);
            this.op = op;
            this.value = new long[value.length];
            for (int i = 0; i < value.length; ++i) {
                this.value[i] = value[i].getTime();
            }
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            switch (this.op.ordinal()) {
                case 0: {
                    builder.in(this.property, this.value);
                    break;
                }
                case 1: {
                    builder.notIn(this.property, this.value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)this.op) + " is not supported for long[]");
                }
            }
        }

        public static enum Operation {
            IN,
            NOT_IN;

        }
    }

    public static class LongLongCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final Operation op;
        private final long leftValue;
        private final long rightValue;

        public LongLongCondition(Property<T> property, Operation op, long leftValue, long rightValue) {
            super(property);
            this.op = op;
            this.leftValue = leftValue;
            this.rightValue = rightValue;
        }

        public LongLongCondition(Property<T> property, Operation op, Date leftValue, Date rightValue) {
            this(property, op, leftValue.getTime(), rightValue.getTime());
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            if (this.op != Operation.BETWEEN) {
                throw new UnsupportedOperationException((Object)((Object)this.op) + " is not supported with two long values");
            }
            builder.between(this.property, this.leftValue, this.rightValue);
        }

        public static enum Operation {
            BETWEEN;

        }
    }

    public static class LongCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final Operation op;
        private final long value;

        public LongCondition(Property<T> property, Operation op, long value) {
            super(property);
            this.op = op;
            this.value = value;
        }

        public LongCondition(Property<T> property, Operation op, boolean value) {
            this(property, op, value ? 1L : 0L);
        }

        public LongCondition(Property<T> property, Operation op, Date value) {
            this(property, op, value.getTime());
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            switch (this.op.ordinal()) {
                case 0: {
                    builder.equal(this.property, this.value);
                    break;
                }
                case 1: {
                    builder.notEqual(this.property, this.value);
                    break;
                }
                case 2: {
                    builder.greater(this.property, this.value);
                    break;
                }
                case 3: {
                    builder.greaterOrEqual(this.property, this.value);
                    break;
                }
                case 4: {
                    builder.less(this.property, this.value);
                    break;
                }
                case 5: {
                    builder.lessOrEqual(this.property, this.value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)this.op) + " is not supported for String");
                }
            }
        }

        public static enum Operation {
            EQUAL,
            NOT_EQUAL,
            GREATER,
            GREATER_OR_EQUAL,
            LESS,
            LESS_OR_EQUAL;

        }
    }

    public static class IntArrayCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final Operation op;
        private final int[] value;

        public IntArrayCondition(Property<T> property, Operation op, int[] value) {
            super(property);
            this.op = op;
            this.value = value;
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            switch (this.op.ordinal()) {
                case 0: {
                    builder.in(this.property, this.value);
                    break;
                }
                case 1: {
                    builder.notIn(this.property, this.value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)this.op) + " is not supported for int[]");
                }
            }
        }

        public static enum Operation {
            IN,
            NOT_IN;

        }
    }

    public static class NullCondition<T>
    extends PropertyQueryConditionImpl<T> {
        private final Operation op;

        public NullCondition(Property<T> property, Operation op) {
            super(property);
            this.op = op;
        }

        @Override
        void applyCondition(QueryBuilder<T> builder) {
            switch (this.op.ordinal()) {
                case 0: {
                    builder.isNull(this.property);
                    break;
                }
                case 1: {
                    builder.notNull(this.property);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)this.op) + " is not supported");
                }
            }
        }

        public static enum Operation {
            IS_NULL,
            NOT_NULL;

        }
    }
}

