/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync;

import io.objectbox.BoxStore;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.exception.FeatureNotAvailableException;
import io.objectbox.sync.SyncClient;
import io.objectbox.sync.SyncClientImpl;
import io.objectbox.sync.SyncCredentials;
import io.objectbox.sync.internal.Platform;
import io.objectbox.sync.listener.SyncChangeListener;
import io.objectbox.sync.listener.SyncCompletedListener;
import io.objectbox.sync.listener.SyncConnectionListener;
import io.objectbox.sync.listener.SyncListener;
import io.objectbox.sync.listener.SyncLoginListener;
import io.objectbox.sync.listener.SyncTimeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public final class SyncBuilder {
    final Platform platform;
    final BoxStore boxStore;
    @Nullable
    private String url;
    final List<SyncCredentials> credentials;
    @Nullable
    SyncLoginListener loginListener;
    @Nullable
    SyncCompletedListener completedListener;
    @Nullable
    SyncChangeListener changeListener;
    @Nullable
    SyncConnectionListener connectionListener;
    @Nullable
    SyncTimeListener timeListener;
    @Nullable
    SyncListener listener;
    @Nullable
    String[] trustedCertPaths;
    boolean uncommittedAcks;
    RequestUpdatesMode requestUpdatesMode = RequestUpdatesMode.AUTO;
    final Map<String, String> filterVariables = new TreeMap<String, String>();

    private static void checkSyncFeatureAvailable() {
        if (!BoxStore.isSyncAvailable()) {
            throw new FeatureNotAvailableException("This library does not include ObjectBox Sync. Please visit https://objectbox.io/sync/ for options.");
        }
    }

    private SyncBuilder(BoxStore boxStore, @Nullable String url, @Nullable List<SyncCredentials> credentials) {
        this.checkNotNull(boxStore, "BoxStore is required.");
        this.checkNotNull(credentials, "Sync credentials are required.");
        this.boxStore = boxStore;
        this.url = url;
        this.credentials = credentials;
        SyncBuilder.checkSyncFeatureAvailable();
        this.platform = Platform.findPlatform();
    }

    @Internal
    public SyncBuilder(BoxStore boxStore, String url, @Nullable SyncCredentials credentials) {
        this(boxStore, url, credentials == null ? null : Collections.singletonList(credentials));
    }

    @Internal
    public SyncBuilder(BoxStore boxStore, String url, @Nullable SyncCredentials[] multipleCredentials) {
        this(boxStore, url, multipleCredentials == null ? null : Arrays.asList(multipleCredentials));
    }

    @Internal
    public SyncBuilder(BoxStore boxStore, @Nullable SyncCredentials credentials) {
        this(boxStore, null, credentials == null ? null : Collections.singletonList(credentials));
    }

    @Internal
    SyncBuilder serverUrl(String url) {
        this.url = url;
        return this;
    }

    @Internal
    String serverUrl() {
        this.checkNotNull(this.url, "Sync Server URL is null.");
        return this.url;
    }

    public SyncBuilder filterVariable(String name, String value) {
        this.checkNotNull(name, "Filter variable name is null.");
        this.checkNotNull(value, "Filter variable value is null.");
        this.filterVariables.put(name, value);
        return this;
    }

    public SyncBuilder trustedCertificates(String[] paths) {
        this.trustedCertPaths = Arrays.copyOf(paths, paths.length);
        return this;
    }

    public SyncBuilder requestUpdatesMode(RequestUpdatesMode requestUpdatesMode) {
        this.requestUpdatesMode = requestUpdatesMode;
        return this;
    }

    public SyncBuilder uncommittedAcks() {
        this.uncommittedAcks = true;
        return this;
    }

    public SyncBuilder loginListener(SyncLoginListener loginListener) {
        this.loginListener = loginListener;
        return this;
    }

    public SyncBuilder completedListener(SyncCompletedListener completedListener) {
        this.completedListener = completedListener;
        return this;
    }

    public SyncBuilder changeListener(SyncChangeListener changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public SyncBuilder timeListener(SyncTimeListener timeListener) {
        this.timeListener = timeListener;
        return this;
    }

    public SyncBuilder connectionListener(SyncConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
        return this;
    }

    public SyncBuilder listener(SyncListener listener) {
        this.listener = listener;
        return this;
    }

    public SyncClient build() {
        if (this.boxStore.getSyncClient() != null) {
            throw new IllegalStateException("The given store is already associated with a Sync client, close it first.");
        }
        this.checkNotNull(this.url, "Sync Server URL is required.");
        return new SyncClientImpl(this);
    }

    public SyncClient buildAndStart() {
        SyncClient syncClient = this.build();
        syncClient.start();
        return syncClient;
    }

    private void checkNotNull(@Nullable Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static enum RequestUpdatesMode {
        MANUAL,
        AUTO,
        AUTO_NO_PUSHES;

    }
}

