/*
 * Copyright 2025 ObjectBox Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// automatically generated by the FlatBuffers compiler, do not modify

package io.objectbox.model;

import io.objectbox.flatbuffers.BaseVector;
import io.objectbox.flatbuffers.BooleanVector;
import io.objectbox.flatbuffers.ByteVector;
import io.objectbox.flatbuffers.Constants;
import io.objectbox.flatbuffers.DoubleVector;
import io.objectbox.flatbuffers.FlatBufferBuilder;
import io.objectbox.flatbuffers.FloatVector;
import io.objectbox.flatbuffers.IntVector;
import io.objectbox.flatbuffers.LongVector;
import io.objectbox.flatbuffers.ShortVector;
import io.objectbox.flatbuffers.StringVector;
import io.objectbox.flatbuffers.Struct;
import io.objectbox.flatbuffers.Table;
import io.objectbox.flatbuffers.UnionVector;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/**
 * A model describes all entities and other meta data.
 * The current model of an app is synced against ObjectBox's persisted schema.
 * The model itself is not persisted, and thus may change as long as both ends are consistent (Java and native).
 * There could be multiple models/schemas (one dbi per schema) in the future.
 */
@SuppressWarnings("unused")
public final class Model extends Table {
  public static void ValidateVersion() { Constants.FLATBUFFERS_23_5_26(); }
  public static Model getRootAsModel(ByteBuffer _bb) { return getRootAsModel(_bb, new Model()); }
  public static Model getRootAsModel(ByteBuffer _bb, Model obj) { _bb.order(ByteOrder.LITTLE_ENDIAN); return (obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb)); }
  public void __init(int _i, ByteBuffer _bb) { __reset(_i, _bb); }
  public Model __assign(int _i, ByteBuffer _bb) { __init(_i, _bb); return this; }

  /**
   * (Meta) version of the model, which is verified by model sync (e.g. Java version must match native version)
   */
  public long modelVersion() { int o = __offset(4); return o != 0 ? (long)bb.getInt(o + bb_pos) & 0xFFFFFFFFL : 0L; }
  /**
   * currently always "default"
   */
  public String name() { int o = __offset(6); return o != 0 ? __string(o + bb_pos) : null; }
  public ByteBuffer nameAsByteBuffer() { return __vector_as_bytebuffer(6, 1); }
  public ByteBuffer nameInByteBuffer(ByteBuffer _bb) { return __vector_in_bytebuffer(_bb, 6, 1); }
  /**
   * User controlled version, not really used at the moment
   */
  public long version() { int o = __offset(8); return o != 0 ? bb.getLong(o + bb_pos) : 0L; }
  public io.objectbox.model.ModelEntity entities(int j) { return entities(new io.objectbox.model.ModelEntity(), j); }
  public io.objectbox.model.ModelEntity entities(io.objectbox.model.ModelEntity obj, int j) { int o = __offset(10); return o != 0 ? obj.__assign(__indirect(__vector(o) + j * 4), bb) : null; }
  public int entitiesLength() { int o = __offset(10); return o != 0 ? __vector_len(o) : 0; }
  public io.objectbox.model.ModelEntity.Vector entitiesVector() { return entitiesVector(new io.objectbox.model.ModelEntity.Vector()); }
  public io.objectbox.model.ModelEntity.Vector entitiesVector(io.objectbox.model.ModelEntity.Vector obj) { int o = __offset(10); return o != 0 ? obj.__assign(__vector(o), 4, bb) : null; }
  public io.objectbox.model.IdUid lastEntityId() { return lastEntityId(new io.objectbox.model.IdUid()); }
  public io.objectbox.model.IdUid lastEntityId(io.objectbox.model.IdUid obj) { int o = __offset(12); return o != 0 ? obj.__assign(o + bb_pos, bb) : null; }
  public io.objectbox.model.IdUid lastIndexId() { return lastIndexId(new io.objectbox.model.IdUid()); }
  public io.objectbox.model.IdUid lastIndexId(io.objectbox.model.IdUid obj) { int o = __offset(14); return o != 0 ? obj.__assign(o + bb_pos, bb) : null; }
  public io.objectbox.model.IdUid lastSequenceId() { return lastSequenceId(new io.objectbox.model.IdUid()); }
  public io.objectbox.model.IdUid lastSequenceId(io.objectbox.model.IdUid obj) { int o = __offset(16); return o != 0 ? obj.__assign(o + bb_pos, bb) : null; }
  public io.objectbox.model.IdUid lastRelationId() { return lastRelationId(new io.objectbox.model.IdUid()); }
  public io.objectbox.model.IdUid lastRelationId(io.objectbox.model.IdUid obj) { int o = __offset(18); return o != 0 ? obj.__assign(o + bb_pos, bb) : null; }
  /**
   * Hash of the model/schema; usually want to check hashes before even creating a model and thus avoiding creating
   * the model altogether. But, at least for now, let language bindings provide it via the model optionally.
   * We use SipHash 128 (16 bytes).
   */
  public int hash(int j) { int o = __offset(20); return o != 0 ? bb.get(__vector(o) + j * 1) & 0xFF : 0; }
  public int hashLength() { int o = __offset(20); return o != 0 ? __vector_len(o) : 0; }
  public ByteVector hashVector() { return hashVector(new ByteVector()); }
  public ByteVector hashVector(ByteVector obj) { int o = __offset(20); return o != 0 ? obj.__assign(__vector(o), bb) : null; }
  public ByteBuffer hashAsByteBuffer() { return __vector_as_bytebuffer(20, 1); }
  public ByteBuffer hashInByteBuffer(ByteBuffer _bb) { return __vector_in_bytebuffer(_bb, 20, 1); }

  public static void startModel(FlatBufferBuilder builder) { builder.startTable(9); }
  public static void addModelVersion(FlatBufferBuilder builder, long modelVersion) { builder.addInt(0, (int) modelVersion, (int) 0L); }
  public static void addName(FlatBufferBuilder builder, int nameOffset) { builder.addOffset(1, nameOffset, 0); }
  public static void addVersion(FlatBufferBuilder builder, long version) { builder.addLong(2, version, 0L); }
  public static void addEntities(FlatBufferBuilder builder, int entitiesOffset) { builder.addOffset(3, entitiesOffset, 0); }
  public static int createEntitiesVector(FlatBufferBuilder builder, int[] data) { builder.startVector(4, data.length, 4); for (int i = data.length - 1; i >= 0; i--) builder.addOffset(data[i]); return builder.endVector(); }
  public static void startEntitiesVector(FlatBufferBuilder builder, int numElems) { builder.startVector(4, numElems, 4); }
  public static void addLastEntityId(FlatBufferBuilder builder, int lastEntityIdOffset) { builder.addStruct(4, lastEntityIdOffset, 0); }
  public static void addLastIndexId(FlatBufferBuilder builder, int lastIndexIdOffset) { builder.addStruct(5, lastIndexIdOffset, 0); }
  public static void addLastSequenceId(FlatBufferBuilder builder, int lastSequenceIdOffset) { builder.addStruct(6, lastSequenceIdOffset, 0); }
  public static void addLastRelationId(FlatBufferBuilder builder, int lastRelationIdOffset) { builder.addStruct(7, lastRelationIdOffset, 0); }
  public static void addHash(FlatBufferBuilder builder, int hashOffset) { builder.addOffset(8, hashOffset, 0); }
  public static int createHashVector(FlatBufferBuilder builder, byte[] data) { return builder.createByteVector(data); }
  public static int createHashVector(FlatBufferBuilder builder, ByteBuffer data) { return builder.createByteVector(data); }
  public static void startHashVector(FlatBufferBuilder builder, int numElems) { builder.startVector(1, numElems, 1); }
  public static int endModel(FlatBufferBuilder builder) {
    int o = builder.endTable();
    return o;
  }
  public static void finishModelBuffer(FlatBufferBuilder builder, int offset) { builder.finish(offset); }
  public static void finishSizePrefixedModelBuffer(FlatBufferBuilder builder, int offset) { builder.finishSizePrefixed(offset); }

  public static final class Vector extends BaseVector {
    public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) { __reset(_vector, _element_size, _bb); return this; }

    public Model get(int j) { return get(new Model(), j); }
    public Model get(Model obj, int j) {  return obj.__assign(__indirect(__element(j), bb), bb); }
  }
}

