/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync.server;

import io.objectbox.annotation.apihint.Internal;
import io.objectbox.sync.listener.SyncChangeListener;
import io.objectbox.sync.server.SyncServer;
import io.objectbox.sync.server.SyncServerBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;

@Internal
public final class SyncServerImpl
implements SyncServer {
    private final URI url;
    private volatile long handle;
    @Nullable
    private volatile SyncChangeListener syncChangeListener;

    SyncServerImpl(SyncServerBuilder builder) {
        this.url = builder.url;
        long storeHandle = builder.boxStore.getNativeStore();
        long handle = SyncServerImpl.nativeCreateFromFlatOptions(storeHandle, builder.buildSyncServerOptions());
        if (handle == 0L) {
            throw new RuntimeException("Failed to create sync server: handle is zero.");
        }
        this.handle = handle;
        if (builder.changeListener != null) {
            this.setSyncChangeListener(builder.changeListener);
        }
    }

    private long getHandle() {
        long handle = this.handle;
        if (handle == 0L) {
            throw new IllegalStateException("SyncServer already closed");
        }
        return handle;
    }

    @Override
    public String getUrl() {
        try {
            return new URI(this.url.getScheme(), null, this.url.getHost(), this.getPort(), null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Server URL can not be constructed", e);
        }
    }

    @Override
    public int getPort() {
        return this.nativeGetPort(this.getHandle());
    }

    @Override
    public boolean isRunning() {
        return this.nativeIsRunning(this.getHandle());
    }

    @Override
    public String getStatsString() {
        return this.nativeGetStatsString(this.getHandle());
    }

    @Override
    public void setSyncChangeListener(@Nullable SyncChangeListener changesListener) {
        this.syncChangeListener = changesListener;
        this.nativeSetSyncChangesListener(this.getHandle(), changesListener);
    }

    @Override
    public void start() {
        this.nativeStart(this.getHandle());
    }

    @Override
    public void stop() {
        this.nativeStop(this.getHandle());
    }

    @Override
    public void close() {
        long handleToDelete = this.handle;
        this.handle = 0L;
        if (handleToDelete != 0L) {
            this.nativeDelete(handleToDelete);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private static native long nativeCreateFromFlatOptions(long var0, byte[] var2);

    private native void nativeDelete(long var1);

    private native void nativeStart(long var1);

    private native void nativeStop(long var1);

    private native boolean nativeIsRunning(long var1);

    private native int nativeGetPort(long var1);

    private native String nativeGetStatsString(long var1);

    private native void nativeSetSyncChangesListener(long var1, @Nullable SyncChangeListener var3);
}

