/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync;

import io.objectbox.sync.SyncCredentialsToken;
import io.objectbox.sync.SyncCredentialsUserPassword;

public abstract class SyncCredentials {
    private final CredentialsType type;

    public static SyncCredentials sharedSecret(String secret) {
        return new SyncCredentialsToken(CredentialsType.SHARED_SECRET_SIPPED, secret);
    }

    public static SyncCredentials sharedSecret(byte[] secret) {
        return new SyncCredentialsToken(CredentialsType.SHARED_SECRET_SIPPED, secret);
    }

    public static SyncCredentials google(String idToken) {
        return new SyncCredentialsToken(CredentialsType.GOOGLE, idToken);
    }

    public static SyncCredentials userAndPassword(String user, String password) {
        return new SyncCredentialsUserPassword(user, password);
    }

    public static SyncCredentials none() {
        return new SyncCredentialsToken(CredentialsType.NONE);
    }

    SyncCredentials(CredentialsType type) {
        this.type = type;
    }

    public CredentialsType getType() {
        return this.type;
    }

    public long getTypeId() {
        return this.type.id;
    }

    abstract SyncCredentials createClone();

    public static enum CredentialsType {
        NONE(1L),
        GOOGLE(3L),
        SHARED_SECRET_SIPPED(4L),
        OBX_ADMIN_USER(5L),
        USER_PASSWORD(6L);

        public final long id;

        private CredentialsType(long id) {
            this.id = id;
        }
    }
}

