/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync.server;

import io.objectbox.annotation.apihint.Internal;
import io.objectbox.sync.SyncCredentials;
import io.objectbox.sync.SyncCredentialsToken;
import io.objectbox.sync.listener.SyncChangeListener;
import io.objectbox.sync.server.PeerInfo;
import io.objectbox.sync.server.SyncServer;
import io.objectbox.sync.server.SyncServerBuilder;
import javax.annotation.Nullable;

@Internal
public class SyncServerImpl
implements SyncServer {
    private final String url;
    private volatile long handle;
    @Nullable
    private volatile SyncChangeListener syncChangeListener;

    SyncServerImpl(SyncServerBuilder builder) {
        SyncCredentialsToken credentialsInternal;
        this.url = builder.url;
        long storeHandle = builder.boxStore.getNativeStore();
        long handle = SyncServerImpl.nativeCreate(storeHandle, this.url, builder.certificatePath);
        if (handle == 0L) {
            throw new RuntimeException("Failed to create sync server: handle is zero.");
        }
        this.handle = handle;
        for (SyncCredentials credentials : builder.credentials) {
            credentialsInternal = (SyncCredentialsToken)credentials;
            this.nativeSetAuthenticator(handle, credentialsInternal.getTypeId(), credentialsInternal.getTokenBytes());
            credentialsInternal.clear();
        }
        for (PeerInfo peer : builder.peers) {
            credentialsInternal = (SyncCredentialsToken)peer.credentials;
            this.nativeAddPeer(handle, peer.url, credentialsInternal.getTypeId(), credentialsInternal.getTokenBytes());
        }
        if (builder.changeListener != null) {
            this.setSyncChangeListener(builder.changeListener);
        }
    }

    private long getHandle() {
        long handle = this.handle;
        if (handle == 0L) {
            throw new IllegalStateException("SyncServer already closed");
        }
        return handle;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public int getPort() {
        return this.nativeGetPort(this.getHandle());
    }

    @Override
    public boolean isRunning() {
        return this.nativeIsRunning(this.getHandle());
    }

    @Override
    public String getStatsString() {
        return this.nativeGetStatsString(this.getHandle());
    }

    @Override
    public void setSyncChangeListener(@Nullable SyncChangeListener changesListener) {
        this.syncChangeListener = changesListener;
        this.nativeSetSyncChangesListener(this.getHandle(), changesListener);
    }

    @Override
    public void start() {
        this.nativeStart(this.getHandle());
    }

    @Override
    public void stop() {
        this.nativeStop(this.getHandle());
    }

    @Override
    public void close() {
        long handleToDelete = this.handle;
        this.handle = 0L;
        if (handleToDelete != 0L) {
            this.nativeDelete(handleToDelete);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private static native long nativeCreate(long var0, String var2, @Nullable String var3);

    private native void nativeDelete(long var1);

    private native void nativeStart(long var1);

    private native void nativeStop(long var1);

    private native boolean nativeIsRunning(long var1);

    private native int nativeGetPort(long var1);

    private native void nativeSetAuthenticator(long var1, long var3, @Nullable byte[] var5);

    private native void nativeAddPeer(long var1, String var3, long var4, @Nullable byte[] var6);

    private native String nativeGetStatsString(long var1);

    private native void nativeSetSyncChangesListener(long var1, @Nullable SyncChangeListener var3);
}

