/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import io.objectbox.BoxStore;
import io.objectbox.EntityInfo;
import io.objectbox.Property;
import io.objectbox.Transaction;
import io.objectbox.annotation.apihint.Beta;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.internal.CursorFactory;
import io.objectbox.relation.ToMany;
import java.io.Closeable;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@Beta
@Internal
@NotThreadSafe
public abstract class Cursor<T>
implements Closeable {
    @Internal
    static boolean TRACK_CREATION_STACK;
    @Internal
    static boolean LOG_READ_NOT_CLOSED;
    protected static final int PUT_FLAG_FIRST = 1;
    protected static final int PUT_FLAG_COMPLETE = 2;
    protected final Transaction tx;
    protected final long cursor;
    protected final EntityInfo<T> entityInfo;
    protected final BoxStore boxStoreForEntities;
    protected final boolean readOnly;
    protected boolean closed;
    private final Throwable creationThrowable;

    native void nativeDestroy(long var1);

    static native boolean nativeDeleteEntity(long var0, long var2);

    native void nativeDeleteAll(long var1);

    static native boolean nativeSeek(long var0, long var2);

    native List<T> nativeGetAllEntities(long var1);

    static native Object nativeGetEntity(long var0, long var2);

    static native Object nativeNextEntity(long var0);

    static native Object nativeFirstEntity(long var0);

    native long nativeCount(long var1, long var3);

    static native long nativeLookupKeyUsingIndex(long var0, int var2, String var3);

    native long nativeRenew(long var1);

    protected static native long collect313311(long var0, long var2, int var4, int var5, @Nullable String var6, int var7, @Nullable String var8, int var9, @Nullable String var10, int var11, @Nullable byte[] var12, int var13, long var14, int var16, long var17, int var19, long var20, int var22, int var23, int var24, int var25, int var26, int var27, int var28, float var29, int var30, double var31);

    protected static native long collect430000(long var0, long var2, int var4, int var5, @Nullable String var6, int var7, @Nullable String var8, int var9, @Nullable String var10, int var11, @Nullable String var12, int var13, @Nullable byte[] var14, int var15, @Nullable byte[] var16, int var17, @Nullable byte[] var18);

    protected static native long collect400000(long var0, long var2, int var4, int var5, @Nullable String var6, int var7, @Nullable String var8, int var9, @Nullable String var10, int var11, @Nullable String var12);

    protected static native long collect002033(long var0, long var2, int var4, int var5, long var6, int var8, long var9, int var11, float var12, int var13, float var14, int var15, float var16, int var17, double var18, int var20, double var21, int var23, double var24);

    protected static native long collect004000(long var0, long var2, int var4, int var5, long var6, int var8, long var9, int var11, long var12, int var14, long var15);

    protected static native long collectStringArray(long var0, long var2, int var4, int var5, @Nullable String[] var6);

    protected static native long collectStringList(long var0, long var2, int var4, int var5, @Nullable List<String> var6);

    native int nativePropertyId(long var1, String var3);

    native List<T> nativeGetBacklinkEntities(long var1, int var3, int var4, long var5);

    native long[] nativeGetBacklinkIds(long var1, int var3, int var4, long var5);

    native List<T> nativeGetRelationEntities(long var1, int var3, int var4, long var5, boolean var7);

    native long[] nativeGetRelationIds(long var1, int var3, int var4, long var5, boolean var7);

    native void nativeModifyRelations(long var1, int var3, long var4, long[] var6, boolean var7);

    native void nativeModifyRelationsSingle(long var1, int var3, long var4, long var6, boolean var8);

    native void nativeSetBoxStoreForEntities(long var1, Object var3);

    native long nativeGetCursorFor(long var1, int var3);

    protected Cursor(Transaction tx, long cursor, EntityInfo<T> entityInfo, BoxStore boxStore) {
        Property<T>[] allProperties;
        if (tx == null) {
            throw new IllegalArgumentException("Transaction is null");
        }
        this.tx = tx;
        this.readOnly = tx.isReadOnly();
        this.cursor = cursor;
        this.entityInfo = entityInfo;
        this.boxStoreForEntities = boxStore;
        for (Property<T> property : allProperties = entityInfo.getAllProperties()) {
            if (property.isIdVerified()) continue;
            int id = this.getPropertyId(property.dbName);
            property.verifyId(id);
        }
        this.creationThrowable = TRACK_CREATION_STACK ? new Throwable() : null;
        this.nativeSetBoxStoreForEntities(cursor, boxStore);
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            if (!this.readOnly || LOG_READ_NOT_CLOSED) {
                System.err.println("Cursor was not closed.");
                if (this.creationThrowable != null) {
                    System.err.println("Cursor was initially created here:");
                    this.creationThrowable.printStackTrace();
                }
                System.err.flush();
            }
            this.close();
            super.finalize();
        }
    }

    protected abstract long getId(T var1);

    public abstract long put(T var1);

    public EntityInfo<T> getEntityInfo() {
        return this.entityInfo;
    }

    public T get(long key) {
        return (T)Cursor.nativeGetEntity(this.cursor, key);
    }

    public T next() {
        return (T)Cursor.nativeNextEntity(this.cursor);
    }

    public T first() {
        return (T)Cursor.nativeFirstEntity(this.cursor);
    }

    public List<T> getAll() {
        return this.nativeGetAllEntities(this.cursor);
    }

    public boolean deleteEntity(long key) {
        return Cursor.nativeDeleteEntity(this.cursor, key);
    }

    public void deleteAll() {
        this.nativeDeleteAll(this.cursor);
    }

    public boolean seek(long key) {
        return Cursor.nativeSeek(this.cursor, key);
    }

    public long count(long maxCountOrZero) {
        return this.nativeCount(this.cursor, maxCountOrZero);
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.tx != null && !this.tx.getStore().isClosed()) {
                this.nativeDestroy(this.cursor);
            }
        }
    }

    public int getPropertyId(String propertyName) {
        return this.nativePropertyId(this.cursor, propertyName);
    }

    long lookupKeyUsingIndex(int propertyId, String value) {
        return Cursor.nativeLookupKeyUsingIndex(this.cursor, propertyId, value);
    }

    public Transaction getTx() {
        return this.tx;
    }

    public boolean isObsolete() {
        return this.tx.isObsolete();
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected <TARGET> Cursor<TARGET> getRelationTargetCursor(Class<TARGET> targetClass) {
        EntityInfo<TARGET> entityInfo = this.boxStoreForEntities.getEntityInfo(targetClass);
        long cursorHandle = this.nativeGetCursorFor(this.cursor, entityInfo.getEntityId());
        CursorFactory<TARGET> factory = entityInfo.getCursorFactory();
        return factory.createCursor(this.tx, cursorHandle, this.boxStoreForEntities);
    }

    public void renew() {
        this.nativeRenew(this.cursor);
    }

    @Internal
    long internalHandle() {
        return this.cursor;
    }

    @Internal
    List<T> getBacklinkEntities(int entityId, Property<?> relationIdProperty, long key) {
        try {
            return this.nativeGetBacklinkEntities(this.cursor, entityId, relationIdProperty.getId(), key);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Please check if the given property belongs to a valid @Relation: " + relationIdProperty, e);
        }
    }

    @Internal
    long[] getBacklinkIds(int entityId, Property<?> relationIdProperty, long key) {
        try {
            return this.nativeGetBacklinkIds(this.cursor, entityId, relationIdProperty.getId(), key);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Please check if the given property belongs to a valid @Relation: " + relationIdProperty, e);
        }
    }

    @Internal
    public List<T> getRelationEntities(int sourceEntityId, int relationId, long key, boolean backlink) {
        return this.nativeGetRelationEntities(this.cursor, sourceEntityId, relationId, key, backlink);
    }

    @Internal
    public long[] getRelationIds(int sourceEntityId, int relationId, long key, boolean backlink) {
        return this.nativeGetRelationIds(this.cursor, sourceEntityId, relationId, key, backlink);
    }

    @Internal
    public void modifyRelations(int relationId, long key, long[] targetKeys, boolean remove) {
        this.nativeModifyRelations(this.cursor, relationId, key, targetKeys, remove);
    }

    @Internal
    public void modifyRelationsSingle(int relationId, long key, long targetKey, boolean remove) {
        this.nativeModifyRelationsSingle(this.cursor, relationId, key, targetKey, remove);
    }

    protected <TARGET> void checkApplyToManyToDb(List<TARGET> relationField, Class<TARGET> targetClass) {
        ToMany toMany;
        if (relationField instanceof ToMany && (toMany = (ToMany)relationField).internalCheckApplyToDbRequired()) {
            try (Cursor<TARGET> targetCursor = this.getRelationTargetCursor(targetClass);){
                toMany.internalApplyToDb(this, targetCursor);
            }
        }
    }

    public String toString() {
        return "Cursor " + Long.toString(this.cursor, 16) + (this.isClosed() ? "(closed)" : "");
    }
}

