/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox;

import java.io.Closeable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class KeyValueCursor
implements Closeable {
    private static final int PUT_FLAG_FIRST = 1;
    private static final int PUT_FLAG_COMPLETE = 2;
    private static final int PUT_FLAG_INSERT_NEW = 4;
    private final long cursor;

    static native void nativePutLongKey(long var0, long var2, byte[] var4);

    static native void nativeDestroy(long var0);

    static native byte[] nativeGetLongKey(long var0, long var2);

    static native byte[] nativeGetNext(long var0);

    static native byte[] nativeGetFirst(long var0);

    static native byte[] nativeGetLast(long var0);

    static native byte[] nativeGetPrev(long var0);

    static native byte[] nativeGetCurrent(long var0);

    static native byte[] nativeGetEqualOrGreater(long var0, long var2);

    static native boolean nativeRemoveAt(long var0, long var2);

    static native boolean nativeSeek(long var0, long var2);

    static native long nativeGetKey(long var0);

    static native void nativeGetKey(long var0, long var2);

    public KeyValueCursor(long cursor) {
        this.cursor = cursor;
    }

    public void put(long key, byte[] data) {
        KeyValueCursor.nativePutLongKey(this.cursor, key, data);
    }

    public byte[] get(long key) {
        return KeyValueCursor.nativeGetLongKey(this.cursor, key);
    }

    public byte[] getNext() {
        return KeyValueCursor.nativeGetNext(this.cursor);
    }

    public byte[] getFirst() {
        return KeyValueCursor.nativeGetFirst(this.cursor);
    }

    public byte[] getLast() {
        return KeyValueCursor.nativeGetLast(this.cursor);
    }

    public byte[] getPrev() {
        return KeyValueCursor.nativeGetPrev(this.cursor);
    }

    public byte[] getEqualOrGreater(long key) {
        return KeyValueCursor.nativeGetEqualOrGreater(this.cursor, key);
    }

    public byte[] getCurrent() {
        return KeyValueCursor.nativeGetCurrent(this.cursor);
    }

    public long getKey() {
        return KeyValueCursor.nativeGetKey(this.cursor);
    }

    public boolean seek(long key) {
        return KeyValueCursor.nativeSeek(this.cursor, key);
    }

    public boolean removeAt(long key) {
        return KeyValueCursor.nativeRemoveAt(this.cursor, key);
    }

    @Override
    public void close() {
        KeyValueCursor.nativeDestroy(this.cursor);
    }
}

