/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.reactive;

import io.objectbox.annotation.apihint.Internal;
import io.objectbox.reactive.DataObserver;
import io.objectbox.reactive.DataPublisher;
import io.objectbox.reactive.DataSubscription;
import io.objectbox.reactive.DataSubscriptionImpl;
import io.objectbox.reactive.DataSubscriptionList;
import io.objectbox.reactive.DataTransformer;
import io.objectbox.reactive.DelegatingObserver;
import io.objectbox.reactive.ErrorObserver;
import io.objectbox.reactive.RunWithParam;
import io.objectbox.reactive.Scheduler;
import io.objectbox.reactive.SubscriptionBuilder;
import io.objectbox.reactive.WeakDataObserver;
import javax.annotation.Nullable;

public class SubscriptionBuilder<T> {
    private final DataPublisher<T> publisher;
    private final Object publisherParam;
    private DataObserver<T> observer;
    private boolean weak;
    private boolean single;
    private boolean onlyChanges;
    private DataTransformer<T, Object> transformer;
    private Scheduler scheduler;
    private ErrorObserver errorObserver;
    private DataSubscriptionList dataSubscriptionList;

    @Internal
    public SubscriptionBuilder(DataPublisher<T> publisher, @Nullable Object param) {
        this.publisher = publisher;
        this.publisherParam = param;
    }

    public SubscriptionBuilder<T> weak() {
        this.weak = true;
        return this;
    }

    public SubscriptionBuilder<T> single() {
        this.single = true;
        return this;
    }

    public SubscriptionBuilder<T> onlyChanges() {
        this.onlyChanges = true;
        return this;
    }

    public <TO> SubscriptionBuilder<TO> transform(DataTransformer<T, TO> transformer) {
        if (this.transformer != null) {
            throw new IllegalStateException("Only one transformer allowed");
        }
        this.transformer = transformer;
        return this;
    }

    public SubscriptionBuilder<T> onError(ErrorObserver errorObserver) {
        if (this.errorObserver != null) {
            throw new IllegalStateException("Only one errorObserver allowed");
        }
        this.errorObserver = errorObserver;
        return this;
    }

    public SubscriptionBuilder<T> on(Scheduler scheduler) {
        if (this.scheduler != null) {
            throw new IllegalStateException("Only one scheduler allowed");
        }
        this.scheduler = scheduler;
        return this;
    }

    public DataSubscription observer(DataObserver<T> observer) {
        WeakDataObserver<T> weakObserver = null;
        if (this.weak) {
            weakObserver = new WeakDataObserver<T>(observer);
            observer = weakObserver;
        }
        this.observer = observer;
        DataSubscriptionImpl<T> subscription = new DataSubscriptionImpl<T>(this.publisher, this.publisherParam, observer);
        if (weakObserver != null) {
            weakObserver.setSubscription(subscription);
        }
        if (this.dataSubscriptionList != null) {
            this.dataSubscriptionList.add(subscription);
        }
        if (this.transformer != null || this.scheduler != null || this.errorObserver != null) {
            observer = new ActionObserver(subscription);
        }
        if (this.single) {
            if (this.onlyChanges) {
                throw new IllegalStateException("Illegal combination of single() and onlyChanges()");
            }
            this.publisher.publishSingle(observer, this.publisherParam);
        } else {
            this.publisher.subscribe(observer, this.publisherParam);
            if (!this.onlyChanges) {
                this.publisher.publishSingle(observer, this.publisherParam);
            }
        }
        return subscription;
    }

    public SubscriptionBuilder<T> dataSubscriptionList(DataSubscriptionList dataSubscriptionList) {
        this.dataSubscriptionList = dataSubscriptionList;
        return this;
    }

    class ActionObserver
    implements DataObserver<T>,
    DelegatingObserver<T> {
        private final DataSubscriptionImpl subscription;
        private io.objectbox.reactive.SubscriptionBuilder$ActionObserver.SchedulerRunOnError schedulerRunOnError;
        private io.objectbox.reactive.SubscriptionBuilder$ActionObserver.SchedulerRunOnChange schedulerRunOnData;

        public ActionObserver(DataSubscriptionImpl subscription) {
            this.subscription = subscription;
            if (SubscriptionBuilder.this.scheduler != null) {
                this.schedulerRunOnData = new SchedulerRunOnChange();
                if (SubscriptionBuilder.this.errorObserver != null) {
                    this.schedulerRunOnError = new SchedulerRunOnError();
                }
            }
        }

        @Override
        public void onData(T data) {
            if (SubscriptionBuilder.this.transformer != null) {
                this.transformAndContinue(data);
            } else {
                this.callOnData(data);
            }
        }

        private void transformAndContinue(T data) {
            if (this.subscription.isCanceled()) {
                return;
            }
            try {
                Object result = SubscriptionBuilder.this.transformer.transform(data);
                this.callOnData(result);
            }
            catch (Throwable th) {
                this.callOnError(th, "Transformer failed without an ErrorObserver set");
            }
        }

        private void callOnError(Throwable th, String msgNoErrorObserver) {
            if (SubscriptionBuilder.this.errorObserver != null) {
                if (!this.subscription.isCanceled()) {
                    if (SubscriptionBuilder.this.scheduler != null) {
                        SubscriptionBuilder.this.scheduler.run((RunWithParam)this.schedulerRunOnError, th);
                    } else {
                        SubscriptionBuilder.this.errorObserver.onError(th);
                    }
                }
            } else {
                RuntimeException exception = new RuntimeException(msgNoErrorObserver, th);
                exception.printStackTrace();
                throw exception;
            }
        }

        void callOnData(T data) {
            if (!this.subscription.isCanceled()) {
                if (SubscriptionBuilder.this.scheduler != null) {
                    SubscriptionBuilder.this.scheduler.run((RunWithParam)this.schedulerRunOnData, data);
                } else {
                    try {
                        SubscriptionBuilder.this.observer.onData(data);
                    }
                    catch (Error | RuntimeException e) {
                        this.callOnError(e, "Observer failed without an ErrorObserver set");
                    }
                }
            }
        }

        @Override
        public DataObserver<T> getObserverDelegate() {
            return SubscriptionBuilder.this.observer;
        }

        class SchedulerRunOnError
        implements RunWithParam<Throwable> {
            SchedulerRunOnError() {
            }

            @Override
            public void run(Throwable data) {
                if (!ActionObserver.this.subscription.isCanceled()) {
                    SubscriptionBuilder.this.errorObserver.onError(data);
                }
            }
        }

        class SchedulerRunOnChange
        implements RunWithParam<T> {
            SchedulerRunOnChange() {
            }

            @Override
            public void run(T data) {
                if (!ActionObserver.this.subscription.isCanceled()) {
                    try {
                        SubscriptionBuilder.this.observer.onData(data);
                    }
                    catch (Error | RuntimeException e) {
                        ActionObserver.this.callOnError(e, "Observer failed without an ErrorObserver set");
                    }
                }
            }
        }
    }
}

