/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle.transform;

import io.objectbox.BoxStoreBuilder;
import io.objectbox.gradle.transform.ClassConst;
import io.objectbox.gradle.transform.ClassTransformerStats;
import io.objectbox.gradle.transform.JavaAssistExtensionsKt;
import io.objectbox.gradle.transform.PrefixedClassPath;
import io.objectbox.gradle.transform.ProbedClass;
import io.objectbox.gradle.transform.TransformException;
import io.objectbox.logging.Logging;
import io.objectbox.reporting.BasicBuildTracker;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u000256B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J6\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J(\u0010\u001a\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J&\u0010\u001d\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u001fH\u0002J\u0018\u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0002J&\u0010%\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020$0'2\u0006\u0010#\u001a\u00020$H\u0002J.\u0010(\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00160'H\u0002J \u0010*\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010-\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010.\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010/\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00100\u001a\u00020$H\u0002J \u00101\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$H\u0002J\u001e\u00102\u001a\u0002032\f\u0010&\u001a\b\u0012\u0004\u0012\u00020$0'2\b\b\u0002\u00104\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lio/objectbox/gradle/transform/ClassTransformer;", "", "debug", "", "(Z)V", "checkBoxStoreField", "ctClass", "Ljavassist/CtClass;", "context", "Lio/objectbox/gradle/transform/ClassTransformer$Context;", "hasRelations", "checkEntityIsInClassPool", "", "classPool", "Ljavassist/ClassPool;", "signature", "", "checkMakeParamCtClasses", "constructor", "Ljavassist/CtConstructor;", "findRelationFields", "", "Lio/objectbox/gradle/transform/ClassTransformer$RelationField;", "ctClassEntity", "fieldTypeDescriptor", "relationType", "findRelationNameInEntityInfo", "field", "Ljavassist/CtField;", "getParamType", "Lkotlin/Pair;", "", "descriptor", "charIndexVal", "makeCtClass", "probedClass", "Lio/objectbox/gradle/transform/ProbedClass;", "makeCtClasses", "probedClasses", "", "transformConstructors", "relationFields", "transformCursor", "outDir", "Ljava/io/File;", "transformCursors", "transformEntities", "transformEntity", "entityClass", "transformEntityAndBases", "transformOrCopyClasses", "Lio/objectbox/gradle/transform/ClassTransformerStats;", "copyNonTransformed", "Context", "RelationField", "objectbox-code-modifier"})
@SourceDebugExtension(value={"SMAP\nClassTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassTransformer.kt\nio/objectbox/gradle/transform/ClassTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,482:1\n1855#2,2:483\n1855#2:485\n1855#2,2:486\n1856#2:488\n766#2:489\n857#2,2:490\n1855#2,2:492\n766#2:494\n857#2,2:495\n1855#2,2:497\n766#2:506\n857#2,2:507\n1855#2,2:509\n1#3:499\n13579#4,2:500\n12744#4,2:502\n12744#4,2:504\n3133#4,11:511\n*S KotlinDebug\n*F\n+ 1 ClassTransformer.kt\nio/objectbox/gradle/transform/ClassTransformer\n*L\n82#1:483,2\n83#1:485\n86#1:486,2\n83#1:488\n99#1:489\n99#1:490,2\n99#1:492,2\n116#1:494\n116#1:495,2\n116#1:497,2\n411#1:506\n411#1:507,2\n411#1:509,2\n241#1:500,2\n284#1:502,2\n292#1:504,2\n432#1:511,11\n*E\n"})
public final class ClassTransformer {
    private final boolean debug;

    public ClassTransformer(boolean debug) {
        this.debug = debug;
    }

    public /* synthetic */ ClassTransformer(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassTransformerStats transformOrCopyClasses(@NotNull List<ProbedClass> probedClasses, boolean copyNonTransformed) {
        Intrinsics.checkNotNullParameter(probedClasses, (String)"probedClasses");
        Context context = new Context(probedClasses);
        Iterable $this$forEach$iv = probedClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProbedClass it = (ProbedClass)element$iv;
            boolean bl = false;
            if (!it.isEntityInfo()) continue;
            this.makeCtClass(context, it);
        }
        $this$forEach$iv = probedClasses;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProbedClass probedClass = (ProbedClass)element$iv;
            boolean bl = false;
            if (!probedClass.isEntity()) continue;
            this.makeCtClasses(context, probedClasses, probedClass);
            Iterable $this$forEach$iv2 = probedClass.getInterfaces();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                context.getClassPool().makeClass(it);
            }
        }
        this.transformEntities(context);
        this.transformCursors(context);
        if (copyNonTransformed) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = probedClasses;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProbedClass it = (ProbedClass)element$iv$iv;
                boolean bl = false;
                if (!(!context.wasTransformed(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProbedClass probedClass = (ProbedClass)element$iv;
                boolean bl = false;
                File outDir = probedClass.component1();
                File file = probedClass.component2();
                String name = probedClass.component3();
                File targetFile = new File(outDir, StringsKt.replace$default((String)name, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class");
                if (Intrinsics.areEqual((Object)file.getPath(), (Object)targetFile.getPath())) continue;
                FilesKt.copyTo$default((File)file, (File)targetFile, (boolean)true, (int)0, (int)4, null);
            }
        }
        context.getStats().setCountTransformed(context.getTransformedClasses().size());
        context.getStats().setCountCopied(copyNonTransformed ? probedClasses.size() - context.getTransformedClasses().size() : 0);
        context.getStats().done();
        return context.getStats();
    }

    public static /* synthetic */ ClassTransformerStats transformOrCopyClasses$default(ClassTransformer classTransformer, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return classTransformer.transformOrCopyClasses(list, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void transformEntities(Context context) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = context.getProbedClasses();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProbedClass it = (ProbedClass)element$iv$iv;
            boolean bl = false;
            if (!it.isEntity()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtClass ctClass;
            ProbedClass entityClass = (ProbedClass)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)context.getCtByProbedClass().get(entityClass));
            this.transformEntityAndBases(context, ctClass, entityClass);
        }
    }

    private final void transformEntityAndBases(Context context, CtClass ctClassEntity, ProbedClass probedClass) {
        CtClass ctClass;
        if (probedClass.getSuperClass() != null) {
            Object v0;
            block9: {
                Iterable iterable = context.getProbedClasses();
                for (Object t : iterable) {
                    ProbedClass it = (ProbedClass)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)probedClass.getSuperClass())) continue;
                    v0 = t;
                    break block9;
                }
                v0 = null;
            }
            ProbedClass probedClass2 = v0;
            if (probedClass2 != null) {
                ProbedClass superClass = probedClass2;
                boolean bl = false;
                this.transformEntityAndBases(context, ctClassEntity, superClass);
            }
        }
        if ((ctClass = context.getCtByProbedClass().get(probedClass)) != null) {
            if (!Intrinsics.areEqual((Object)ctClass, (Object)ctClassEntity) && probedClass.hasRelation(context.getEntityTypes()) && (probedClass.isEntity() || probedClass.isBaseEntity())) {
                throw new TransformException("Relations in an entity super class are not supported, but '" + ctClass.getName() + "' is super of entity '" + ctClassEntity.getName() + "' and has relations");
            }
            if (Intrinsics.areEqual((Object)ctClass, (Object)ctClassEntity) || probedClass.isBaseEntity()) {
                try {
                    if (this.transformEntity(context, ctClassEntity, ctClass, probedClass)) {
                        context.getTransformedClasses().add(probedClass);
                    }
                }
                catch (Exception e) {
                    throw new TransformException("Could not transform class \"" + ctClass.getName() + "\" (" + e.getMessage() + ')', e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CtClass makeCtClass(Context context, ProbedClass probedClass) {
        Closeable closeable = new FileInputStream(probedClass.getFile());
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            CtClass ctClass = context.getClassPool().makeClass((InputStream)it);
            Map<ProbedClass, CtClass> map = context.getCtByProbedClass();
            Intrinsics.checkNotNullExpressionValue((Object)ctClass, (String)"ctClass");
            map.put(probedClass, ctClass);
            CtClass ctClass2 = ctClass;
            return ctClass2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void makeCtClasses(Context context, List<ProbedClass> probedClasses, ProbedClass probedClass) {
        if (probedClass.getSuperClass() != null && ((CharSequence)probedClass.getSuperClass()).length() > 0) {
            Object v0;
            block3: {
                Iterable iterable = probedClasses;
                for (Object t : iterable) {
                    ProbedClass it = (ProbedClass)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)probedClass.getSuperClass())) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            ProbedClass superClass = v0;
            if (superClass != null) {
                this.makeCtClasses(context, probedClasses, superClass);
            }
        }
        this.makeCtClass(context, probedClass);
    }

    private final boolean transformEntity(Context context, CtClass ctClassEntity, CtClass ctClass, ProbedClass entityClass) {
        boolean hasRelations = entityClass.hasRelation(context.getEntityTypes());
        if (this.debug) {
            Logging.log("Checking to transform \"" + ctClass.getName() + "\" (has relations: " + hasRelations + ')');
        }
        boolean changed = this.checkBoxStoreField(ctClass, context, hasRelations);
        if (hasRelations) {
            List<RelationField> toOneFields = this.findRelationFields(context, ctClassEntity, ctClass, "Lio/objectbox/relation/ToOne;", "io.objectbox.relation.ToOne");
            ClassTransformerStats classTransformerStats = context.getStats();
            classTransformerStats.setToOnesFound(classTransformerStats.getToOnesFound() + toOneFields.size());
            List<RelationField> toManyFields = this.findRelationFields(context, ctClassEntity, ctClass, "Lio/objectbox/relation/ToMany;", "io.objectbox.relation.ToMany");
            List<RelationField> listToEntityFields = this.findRelationFields(context, ctClassEntity, ctClass, "Ljava/util/List;", "io.objectbox.relation.ToMany");
            CollectionsKt.addAll((Collection)toManyFields, (Iterable)listToEntityFields);
            ClassTransformerStats classTransformerStats2 = context.getStats();
            classTransformerStats2.setToManyFound(classTransformerStats2.getToManyFound() + toManyFields.size());
            if (this.transformConstructors(context, ctClassEntity, ctClass, CollectionsKt.plus((Collection)toOneFields, (Iterable)toManyFields))) {
                changed = true;
            }
        }
        if (changed) {
            if (this.debug) {
                Logging.log("Writing transformed entity \"" + ctClass.getName() + '\"');
            }
            ctClass.writeFile(entityClass.getOutDir().getAbsolutePath());
        }
        return changed;
    }

    private final boolean checkBoxStoreField(CtClass ctClass, Context context, boolean hasRelations) {
        Object object;
        boolean changed;
        block4: {
            changed = false;
            CtField[] ctFieldArray = ctClass.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)ctFieldArray, (String)"ctClass.declaredFields");
            for (Object object2 : (Object[])ctFieldArray) {
                CtField it = (CtField)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"__boxStore")) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        CtField boxStoreField = (CtField)object;
        if (boxStoreField != null && Modifier.isPrivate((int)boxStoreField.getModifiers())) {
            boxStoreField.setModifiers(boxStoreField.getModifiers() ^ 2);
            ClassTransformerStats classTransformerStats = context.getStats();
            int n = classTransformerStats.getBoxStoreFieldsMadeVisible();
            classTransformerStats.setBoxStoreFieldsMadeVisible(n + 1);
            changed = true;
        } else if (boxStoreField == null && hasRelations) {
            String code = "transient io.objectbox.BoxStore __boxStore;";
            boxStoreField = CtField.make((String)code, (CtClass)ctClass);
            ctClass.addField(boxStoreField);
            ClassTransformerStats classTransformerStats = context.getStats();
            int n = classTransformerStats.getBoxStoreFieldsAdded();
            classTransformerStats.setBoxStoreFieldsAdded(n + 1);
            changed = true;
        }
        return changed;
    }

    /*
     * Unable to fully structure code
     */
    private final List<RelationField> findRelationFields(Context context, CtClass ctClassEntity, CtClass ctClass, String fieldTypeDescriptor, String relationType) {
        fields = new ArrayList<E>();
        v0 = ctClass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ctClass.declaredFields");
        var7_7 = v0;
        $i$f$forEach = false;
        for (void element$iv : $this$forEach$iv) {
            field = (CtField)element$iv;
            $i$a$-forEach-ClassTransformer$findRelationFields$1 = false;
            if (!Intrinsics.areEqual((Object)field.getFieldInfo().getDescriptor(), (Object)fieldTypeDescriptor) || Modifier.isTransient((int)field.getModifiers())) continue;
            v1 = field.getFieldInfo();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"field.fieldInfo");
            if (JavaAssistExtensionsKt.exGetAnnotation(v1, ClassConst.INSTANCE.getTransientAnnotationName()) != null) ** GOTO lbl-1000
            v2 = field.getFieldInfo();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"field.fieldInfo");
            if (JavaAssistExtensionsKt.exGetAnnotation(v2, ClassConst.INSTANCE.getConvertAnnotationName()) != null) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = hasTransientOrConvertAnnotation = false;
            }
            if (hasTransientOrConvertAnnotation) continue;
            v4 = field.getFieldInfo();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"field.fieldInfo");
            targetClassType = JavaAssistExtensionsKt.exGetSingleGenericTypeArgumentOrNull(v4);
            if (targetClassType == null || !context.getEntityTypes().contains(targetClassType.getName())) continue;
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            name = this.findRelationNameInEntityInfo(context, ctClassEntity, field, relationType);
            ((Collection)fields).add(new RelationField(field, name, relationType, targetClassType));
        }
        return fields;
    }

    private final String findRelationNameInEntityInfo(Context context, CtClass ctClass, CtField field, String relationType) {
        boolean bl;
        String name;
        CtClass entityInfoCtClass;
        String entityInfoClassName;
        block11: {
            CtClass ctClass2;
            entityInfoClassName = ctClass.getName() + '_';
            try {
                ctClass2 = context.getClassPool().get(entityInfoClassName);
            }
            catch (NotFoundException e) {
                throw new TransformException("Could not find generated class \"" + entityInfoClassName + "\", please ensure that ObjectBox class generation runs properly before");
            }
            entityInfoCtClass = ctClass2;
            name = null;
            name = field.getName();
            CtField[] ctFieldArray = entityInfoCtClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)ctFieldArray, (String)"entityInfoCtClass.fields");
            Object[] $this$any$iv = ctFieldArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                CtField it = (CtField)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                bl = true;
                break block11;
            }
            bl = false;
        }
        if (!bl) {
            String string;
            String $i$f$any = relationType;
            if (Intrinsics.areEqual((Object)$i$f$any, (Object)"io.objectbox.relation.ToOne")) {
                string = "ToOne";
            } else if (Intrinsics.areEqual((Object)$i$f$any, (Object)"io.objectbox.relation.ToMany")) {
                string = "ToMany";
            } else {
                throw new TransformException("Unexpected " + relationType);
            }
            String suffix = string;
            String string2 = name;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            if (StringsKt.endsWith$default((String)string2, (String)suffix, (boolean)false, (int)2, null)) {
                boolean bl3;
                String name2;
                block12: {
                    String string3 = name;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
                    name2 = StringsKt.dropLast((String)string3, (int)suffix.length());
                    CtField[] ctFieldArray = entityInfoCtClass.getFields();
                    Intrinsics.checkNotNullExpressionValue((Object)ctFieldArray, (String)"entityInfoCtClass.fields");
                    Object[] $this$any$iv = ctFieldArray;
                    boolean $i$f$any2 = false;
                    for (Object element$iv : $this$any$iv) {
                        CtField it = (CtField)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                        bl3 = true;
                        break block12;
                    }
                    bl3 = false;
                }
                if (!bl3) {
                    throw new TransformException("Could not find RelationInfo element for relation field \"" + ctClass.getName() + '.' + name + "\" in generated class \"" + entityInfoClassName + '\"');
                }
                name = name2;
            }
        }
        String string = name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return string;
    }

    private final boolean transformConstructors(Context context, CtClass ctClassEntity, CtClass ctClass, List<RelationField> relationFields) {
        boolean changed = false;
        Set initializedRelationFields = new LinkedHashSet();
        CtConstructor[] ctConstructorArray = ctClass.getConstructors();
        Intrinsics.checkNotNullExpressionValue((Object)ctConstructorArray, (String)"ctClass.constructors");
        for (CtConstructor constructor : ctConstructorArray) {
            if (!constructor.callsSuper()) {
                if (!this.debug) continue;
                Logging.log("Skipping constructor " + constructor.getLongName() + " calling another constructor");
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)constructor, (String)"constructor");
            this.checkMakeParamCtClasses(context, constructor);
            ClassTransformerStats classTransformerStats = context.getStats();
            int n = classTransformerStats.getConstructorsCheckedForTransform();
            classTransformerStats.setConstructorsCheckedForTransform(n + 1);
            ClassFile classFile = ctClass.getClassFile();
            Intrinsics.checkNotNullExpressionValue((Object)classFile, (String)"ctClass.classFile");
            MethodInfo methodInfo = constructor.getMethodInfo();
            Intrinsics.checkNotNullExpressionValue((Object)methodInfo, (String)"constructor.methodInfo");
            HashSet<String> initializedFields = JavaAssistExtensionsKt.getInitializedFields(classFile, methodInfo);
            for (RelationField field : relationFields) {
                String fieldName = field.getCtField().getName();
                if (!initializedFields.contains(fieldName)) {
                    int n2;
                    ClassTransformerStats classTransformerStats2;
                    String code = "$0." + fieldName + " = new " + field.getRelationType() + "($0, " + ctClassEntity.getName() + "_#" + field.getRelationName() + ");";
                    try {
                        constructor.insertBeforeBody(code);
                    }
                    catch (Exception e) {
                        throw new TransformException("Could not insert init code for field " + fieldName + " in constructor", e);
                    }
                    if (Intrinsics.areEqual((Object)field.getRelationType(), (Object)"io.objectbox.relation.ToOne")) {
                        classTransformerStats2 = context.getStats();
                        n2 = classTransformerStats2.getToOnesInitializerAdded();
                        classTransformerStats2.setToOnesInitializerAdded(n2 + 1);
                    } else if (Intrinsics.areEqual((Object)field.getRelationType(), (Object)"io.objectbox.relation.ToMany")) {
                        classTransformerStats2 = context.getStats();
                        n2 = classTransformerStats2.getToManyInitializerAdded();
                        classTransformerStats2.setToManyInitializerAdded(n2 + 1);
                    }
                    changed = true;
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)fieldName, (String)"fieldName");
                initializedRelationFields.add(fieldName);
            }
        }
        if (!((Collection)initializedRelationFields).isEmpty()) {
            String fieldNames = CollectionsKt.joinToString$default((Iterable)initializedRelationFields, null, null, null, (int)0, null, null, (int)63, null);
            Logging.log("In '" + ctClass.getName() + "' relation fields (" + fieldNames + ") are initialized, make sure to read https://docs.objectbox.io/relations#initialization-magic");
        }
        return changed;
    }

    private final void checkMakeParamCtClasses(Context context, CtConstructor constructor) {
        try {
            int count = Descriptor.numOfParameters((String)constructor.getSignature());
            int charIndex = 1;
            for (int i = 0; i < count; ++i) {
                String string = constructor.getSignature();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructor.signature");
                Pair<String, Integer> paramPair = this.getParamType(string, charIndex);
                String paramClass = (String)paramPair.getFirst();
                if (paramClass != null && context.getClassPool().getOrNull(paramClass) == null) {
                    context.getClassPool().makeClass(paramClass);
                }
                if (!(charIndex != ((Number)paramPair.getSecond()).intValue())) {
                    String string2 = "Check failed.";
                    throw new IllegalStateException(string2.toString());
                }
                charIndex = ((Number)paramPair.getSecond()).intValue();
            }
        }
        catch (Exception e) {
            BasicBuildTracker.trackError$default(new BasicBuildTracker("Transformer"), "Could not define class for params: " + constructor.getSignature(), null, 2, null);
        }
        try {
            String lastExMsg = "";
            while (true) {
                try {
                    constructor.getParameterTypes();
                }
                catch (NotFoundException e) {
                    String message = e.getMessage();
                    if (message != null && !Intrinsics.areEqual((Object)message, (Object)lastExMsg) && !StringsKt.contains$default((CharSequence)message, (char)' ', (boolean)false, (int)2, null)) {
                        context.getClassPool().makeClass(message);
                        lastExMsg = message;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            BasicBuildTracker.trackError$default(new BasicBuildTracker("Transformer"), "Could not define class for params (2): " + constructor.getSignature(), null, 2, null);
        }
    }

    private final Pair<String, Integer> getParamType(String descriptor, int charIndexVal) {
        Pair pair;
        int charIndex = charIndexVal;
        char c = descriptor.charAt(charIndex);
        while (c == '[') {
            c = descriptor.charAt(++charIndex);
        }
        if (c == 'L') {
            int endIndex = StringsKt.indexOf$default((CharSequence)descriptor, (char)';', (int)(++charIndex), (boolean)false, (int)4, null);
            String string = descriptor.substring(charIndex, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String name = StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null);
            pair = new Pair((Object)name, (Object)(endIndex + 1));
        } else {
            pair = new Pair(null, (Object)(charIndex + 1));
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final void transformCursors(Context context) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = context.getProbedClasses();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProbedClass it = (ProbedClass)element$iv$iv;
            boolean bl = false;
            if (!it.isCursor()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProbedClass cursorClass = (ProbedClass)element$iv;
            boolean bl = false;
            CtClass ctClass = this.makeCtClass(context, cursorClass);
            try {
                if (!this.transformCursor(ctClass, cursorClass.getOutDir(), context.getClassPool())) continue;
                context.getTransformedClasses().add(cursorClass);
            }
            catch (Exception e) {
                throw new TransformException("Could not transform Cursor class \"" + ctClass.getName() + "\" (" + e.getMessage() + ')', e);
            }
        }
    }

    private final boolean transformCursor(CtClass ctClass, File outDir, ClassPool classPool) {
        CtMethod attachCtMethod;
        block9: {
            CtMethod ctMethod;
            CtMethod[] ctMethodArray = ctClass.getDeclaredMethods();
            if (ctMethodArray != null) {
                CtMethod[] $this$singleOrNull$iv = ctMethodArray;
                boolean $i$f$singleOrNull = false;
                CtMethod single$iv = null;
                boolean found$iv = false;
                int n = $this$singleOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    CtMethod element$iv;
                    CtMethod it = element$iv = $this$singleOrNull$iv[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"attachEntity")) continue;
                    if (found$iv) {
                        ctMethod = null;
                        break block9;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                ctMethod = !found$iv ? null : single$iv;
            } else {
                ctMethod = attachCtMethod = null;
            }
        }
        if (attachCtMethod != null) {
            String signature = attachCtMethod.getSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"signature");
            if (!StringsKt.startsWith$default((String)signature, (String)"(L", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)signature, (String)";)V", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)signature, (char)',', (boolean)false, (int)2, null)) {
                throw new TransformException(ctClass.getName() + " The signature of attachEntity is not as expected, but was '" + signature + "'.");
            }
            byte[] existingCode = attachCtMethod.getMethodInfo().getCodeAttribute().getCode();
            if (existingCode.length != 1 || existingCode[0] != -79) {
                Logging.logWarning(ctClass.getName() + ".attachEntity  body expected to be empty, might lead to unexpected behavior.");
            }
            if (JavaAssistExtensionsKt.assignsBoxStoreField(attachCtMethod)) {
                Logging.log(ctClass.getName() + ".attachEntity assigns __boxStore, make sure to read https://docs.objectbox.io/relations#initialization-magic.");
                return false;
            }
            this.checkEntityIsInClassPool(classPool, signature);
            String code = "$1.__boxStore = $0.boxStoreForEntities;";
            attachCtMethod.insertAfter(code);
            if (this.debug) {
                Logging.log("Writing transformed cursor '" + ctClass.getName() + '\'');
            }
            ctClass.writeFile(outDir.getAbsolutePath());
            return true;
        }
        return false;
    }

    private final void checkEntityIsInClassPool(ClassPool classPool, String signature) {
        String entityClass = StringsKt.replace$default((String)StringsKt.dropLast((String)StringsKt.drop((String)signature, (int)2), (int)3), (char)'/', (char)'.', (boolean)false, (int)4, null);
        CtClass entityCtClass = null;
        try {
            entityCtClass = classPool.get(entityClass);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (entityCtClass == null) {
            System.out.println((Object)("Warning: cursor transformer did not find entity class " + entityClass));
            entityCtClass = classPool.makeClass(entityClass);
            String fieldCode = "transient io.objectbox.BoxStore __boxStore;";
            entityCtClass.addField(CtField.make((String)fieldCode, (CtClass)entityCtClass));
        }
    }

    public ClassTransformer() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006 "}, d2={"Lio/objectbox/gradle/transform/ClassTransformer$Context;", "", "probedClasses", "", "Lio/objectbox/gradle/transform/ProbedClass;", "(Ljava/util/List;)V", "classPool", "Ljavassist/ClassPool;", "getClassPool", "()Ljavassist/ClassPool;", "ctByProbedClass", "", "Ljavassist/CtClass;", "getCtByProbedClass", "()Ljava/util/Map;", "entityTypes", "", "", "getEntityTypes", "()Ljava/util/Set;", "getProbedClasses", "()Ljava/util/List;", "stats", "Lio/objectbox/gradle/transform/ClassTransformerStats;", "getStats", "()Lio/objectbox/gradle/transform/ClassTransformerStats;", "transformedClasses", "", "getTransformedClasses", "wasTransformed", "", "probedClass", "objectbox-code-modifier"})
    @SourceDebugExtension(value={"SMAP\nClassTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassTransformer.kt\nio/objectbox/gradle/transform/ClassTransformer$Context\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,482:1\n766#2:483\n857#2,2:484\n1549#2:486\n1620#2,3:487\n*S KotlinDebug\n*F\n+ 1 ClassTransformer.kt\nio/objectbox/gradle/transform/ClassTransformer$Context\n*L\n48#1:483\n48#1:484,2\n48#1:486\n48#1:487,3\n*E\n"})
    public static final class Context {
        @NotNull
        private final List<ProbedClass> probedClasses;
        @NotNull
        private final ClassPool classPool;
        @NotNull
        private final Set<ProbedClass> transformedClasses;
        @NotNull
        private final Map<ProbedClass, CtClass> ctByProbedClass;
        @NotNull
        private final Set<String> entityTypes;
        @NotNull
        private final ClassTransformerStats stats;

        /*
         * WARNING - void declaration
         */
        public Context(@NotNull List<ProbedClass> probedClasses) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ProbedClass it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter(probedClasses, (String)"probedClasses");
            this.probedClasses = probedClasses;
            this.classPool = new ClassPool();
            this.transformedClasses = new LinkedHashSet();
            this.ctByProbedClass = new LinkedHashMap();
            Iterable iterable = this.probedClasses;
            Context context = this;
            boolean $i$f$filter = false;
            void var4_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ProbedClass)element$iv$iv;
                boolean bl = false;
                if (!it.isEntity()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ProbedClass)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            context.entityTypes = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            this.stats = new ClassTransformerStats();
            String objectBoxPath = BoxStoreBuilder.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String decodedObjectBoxPath = URLDecoder.decode(objectBoxPath, "UTF-8");
            this.classPool.appendClassPath(decodedObjectBoxPath);
            this.classPool.appendClassPath((ClassPath)new PrefixedClassPath("java.", Object.class));
        }

        @NotNull
        public final List<ProbedClass> getProbedClasses() {
            return this.probedClasses;
        }

        @NotNull
        public final ClassPool getClassPool() {
            return this.classPool;
        }

        @NotNull
        public final Set<ProbedClass> getTransformedClasses() {
            return this.transformedClasses;
        }

        @NotNull
        public final Map<ProbedClass, CtClass> getCtByProbedClass() {
            return this.ctByProbedClass;
        }

        @NotNull
        public final Set<String> getEntityTypes() {
            return this.entityTypes;
        }

        @NotNull
        public final ClassTransformerStats getStats() {
            return this.stats;
        }

        public final boolean wasTransformed(@NotNull ProbedClass probedClass) {
            Intrinsics.checkNotNullParameter((Object)probedClass, (String)"probedClass");
            return this.transformedClasses.contains(probedClass);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lio/objectbox/gradle/transform/ClassTransformer$RelationField;", "", "ctField", "Ljavassist/CtField;", "relationName", "", "relationType", "targetTypeSignature", "Ljavassist/bytecode/SignatureAttribute$ClassType;", "(Ljavassist/CtField;Ljava/lang/String;Ljava/lang/String;Ljavassist/bytecode/SignatureAttribute$ClassType;)V", "getCtField", "()Ljavassist/CtField;", "getRelationName", "()Ljava/lang/String;", "getRelationType", "getTargetTypeSignature", "()Ljavassist/bytecode/SignatureAttribute$ClassType;", "objectbox-code-modifier"})
    private static final class RelationField {
        @NotNull
        private final CtField ctField;
        @NotNull
        private final String relationName;
        @NotNull
        private final String relationType;
        @Nullable
        private final SignatureAttribute.ClassType targetTypeSignature;

        public RelationField(@NotNull CtField ctField, @NotNull String relationName, @NotNull String relationType, @Nullable SignatureAttribute.ClassType targetTypeSignature) {
            Intrinsics.checkNotNullParameter((Object)ctField, (String)"ctField");
            Intrinsics.checkNotNullParameter((Object)relationName, (String)"relationName");
            Intrinsics.checkNotNullParameter((Object)relationType, (String)"relationType");
            this.ctField = ctField;
            this.relationName = relationName;
            this.relationType = relationType;
            this.targetTypeSignature = targetTypeSignature;
        }

        @NotNull
        public final CtField getCtField() {
            return this.ctField;
        }

        @NotNull
        public final String getRelationName() {
            return this.relationName;
        }

        @NotNull
        public final String getRelationType() {
            return this.relationType;
        }

        @Nullable
        public final SignatureAttribute.ClassType getTargetTypeSignature() {
            return this.targetTypeSignature;
        }
    }
}

