/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.android;

import androidx.annotation.NonNull;
import androidx.paging.DataSource;
import androidx.paging.PositionalDataSource;
import io.objectbox.query.Query;
import io.objectbox.reactive.DataObserver;
import java.util.Collections;
import java.util.List;

public class ObjectBoxDataSource<T>
extends PositionalDataSource<T> {
    private final Query<T> query;
    private final DataObserver<List<T>> observer;

    public ObjectBoxDataSource(Query<T> query) {
        this.query = query;
        this.observer = new DataObserver<List<T>>(){

            public void onData(@NonNull List<T> data) {
                ObjectBoxDataSource.this.invalidate();
            }
        };
        query.subscribe().onlyChanges().weak().observer(this.observer);
    }

    public void loadInitial(@NonNull PositionalDataSource.LoadInitialParams params, @NonNull PositionalDataSource.LoadInitialCallback<T> callback) {
        int loadSize;
        int totalCount = (int)this.query.count();
        if (totalCount == 0) {
            callback.onResult(Collections.emptyList(), 0, 0);
            return;
        }
        int position = ObjectBoxDataSource.computeInitialLoadPosition((PositionalDataSource.LoadInitialParams)params, (int)totalCount);
        List<T> list = this.loadRange(position, loadSize = ObjectBoxDataSource.computeInitialLoadSize((PositionalDataSource.LoadInitialParams)params, (int)position, (int)totalCount));
        if (list.size() == loadSize) {
            callback.onResult(list, position, totalCount);
        } else {
            this.invalidate();
        }
    }

    public void loadRange(@NonNull PositionalDataSource.LoadRangeParams params, @NonNull PositionalDataSource.LoadRangeCallback<T> callback) {
        callback.onResult(this.loadRange(params.startPosition, params.loadSize));
    }

    private List<T> loadRange(int startPosition, int loadCount) {
        return this.query.find((long)startPosition, (long)loadCount);
    }

    public static class Factory<Item>
    extends DataSource.Factory<Integer, Item> {
        private final Query<Item> query;

        public Factory(Query<Item> query) {
            this.query = query;
        }

        public DataSource<Integer, Item> create() {
            return new ObjectBoxDataSource<Item>(this.query);
        }
    }
}

