/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import io.objectbox.android.AndroidObjectBrowser;
import io.objectbox.android.AndroidObjectBrowserService;

public class AndroidObjectBrowserReceiver
extends BroadcastReceiver {
    private static final String TAG = "ObjectBrowserReceiver";
    static final String ACTION_KEEP_ALIVE = "io.objectbox.action.KEEP_ALIVE";

    public void onReceive(Context context, Intent intent) {
        if (!ACTION_KEEP_ALIVE.equals(intent.getAction())) {
            return;
        }
        if (!intent.hasExtra("url")) {
            Log.w((String)TAG, (String)"Ignoring keep alive intent due to incomplete data");
            return;
        }
        Intent serviceIntent = new Intent(context, AndroidObjectBrowserService.class);
        serviceIntent.putExtras(intent);
        if (Build.VERSION.SDK_INT >= 26) {
            context.startForegroundService(serviceIntent);
        } else {
            context.startService(serviceIntent);
        }
        String url = intent.getStringExtra("url");
        context.startActivity(AndroidObjectBrowser.viewIntent(url));
    }
}

