/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.linkify;

import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import androidx.annotation.NonNull;
import androidx.core.text.util.LinkifyCompat;
import io.noties.markwon.AbstractMarkwonPlugin;
import io.noties.markwon.MarkwonPlugin;
import io.noties.markwon.MarkwonVisitor;
import io.noties.markwon.RenderProps;
import io.noties.markwon.SpanFactory;
import io.noties.markwon.SpannableBuilder;
import io.noties.markwon.core.CorePlugin;
import io.noties.markwon.core.CoreProps;
import org.commonmark.node.Link;

public class LinkifyPlugin
extends AbstractMarkwonPlugin {
    private final int mask;
    private final boolean useCompat;

    @NonNull
    public static LinkifyPlugin create() {
        return LinkifyPlugin.create(false);
    }

    @NonNull
    public static LinkifyPlugin create(boolean useCompat) {
        return LinkifyPlugin.create(7, useCompat);
    }

    @NonNull
    public static LinkifyPlugin create(int mask) {
        return new LinkifyPlugin(mask, false);
    }

    @NonNull
    public static LinkifyPlugin create(int mask, boolean useCompat) {
        return new LinkifyPlugin(mask, useCompat);
    }

    LinkifyPlugin(int mask, boolean useCompat) {
        this.mask = mask;
        this.useCompat = useCompat;
    }

    public void configure(@NonNull MarkwonPlugin.Registry registry) {
        registry.require(CorePlugin.class, (MarkwonPlugin.Action)new MarkwonPlugin.Action<CorePlugin>(){

            public void apply(@NonNull CorePlugin corePlugin) {
                LinkifyTextAddedListener listener = LinkifyPlugin.this.useCompat ? new LinkifyCompatTextAddedListener(LinkifyPlugin.this.mask) : new LinkifyTextAddedListener(LinkifyPlugin.this.mask);
                corePlugin.addOnTextAddedListener((CorePlugin.OnTextAddedListener)listener);
            }
        });
    }

    private static class LinkifyCompatTextAddedListener
    extends LinkifyTextAddedListener {
        LinkifyCompatTextAddedListener(int mask) {
            super(mask);
        }

        @Override
        protected boolean addLinks(@NonNull Spannable text, int mask) {
            return LinkifyCompat.addLinks((Spannable)text, (int)mask);
        }
    }

    private static class LinkifyTextAddedListener
    implements CorePlugin.OnTextAddedListener {
        private final int mask;

        LinkifyTextAddedListener(int mask) {
            this.mask = mask;
        }

        public void onTextAdded(@NonNull MarkwonVisitor visitor, @NonNull String text, int start) {
            URLSpan[] spans;
            SpanFactory spanFactory = visitor.configuration().spansFactory().get(Link.class);
            if (spanFactory == null) {
                return;
            }
            SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)text);
            if (this.addLinks((Spannable)builder, this.mask) && (spans = (URLSpan[])builder.getSpans(0, builder.length(), URLSpan.class)) != null && spans.length > 0) {
                RenderProps renderProps = visitor.renderProps();
                SpannableBuilder spannableBuilder = visitor.builder();
                for (URLSpan span : spans) {
                    CoreProps.LINK_DESTINATION.set(renderProps, (Object)span.getURL());
                    SpannableBuilder.setSpans((SpannableBuilder)spannableBuilder, (Object)spanFactory.getSpans(visitor.configuration(), renderProps), (int)(start + builder.getSpanStart((Object)span)), (int)(start + builder.getSpanEnd((Object)span)));
                }
            }
        }

        protected boolean addLinks(@NonNull Spannable text, int mask) {
            return Linkify.addLinks((Spannable)text, (int)mask);
        }
    }
}

