/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.inlineparser;

import io.noties.markwon.inlineparser.InlineProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.Text;

public class NewLineInlineProcessor
extends InlineProcessor {
    private static final Pattern FINAL_SPACE = Pattern.compile(" *$");

    @Override
    public char specialCharacter() {
        return '\n';
    }

    @Override
    protected Node parse() {
        ++this.index;
        Node previous = this.block.getLastChild();
        if (previous instanceof Text && ((Text)previous).getLiteral().endsWith(" ")) {
            int spaces;
            Text text = (Text)previous;
            String literal = text.getLiteral();
            Matcher matcher = FINAL_SPACE.matcher(literal);
            int n = spaces = matcher.find() ? matcher.end() - matcher.start() : 0;
            if (spaces > 0) {
                text.setLiteral(literal.substring(0, literal.length() - spaces));
            }
            if (spaces >= 2) {
                return new HardLineBreak();
            }
            return new SoftLineBreak();
        }
        return new SoftLineBreak();
    }
}

