/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.inlineparser;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.inlineparser.MarkwonInlineParserContext;
import java.util.regex.Pattern;
import org.commonmark.internal.Bracket;
import org.commonmark.internal.Delimiter;
import org.commonmark.node.Node;
import org.commonmark.node.Text;

public abstract class InlineProcessor {
    protected MarkwonInlineParserContext context;
    protected Node block;
    protected String input;
    protected int index;

    public abstract char specialCharacter();

    @Nullable
    protected abstract Node parse();

    @Nullable
    public Node parse(@NonNull MarkwonInlineParserContext context) {
        this.context = context;
        this.block = context.block();
        this.input = context.input();
        this.index = context.index();
        Node result = this.parse();
        context.setIndex(this.index);
        return result;
    }

    protected Bracket lastBracket() {
        return this.context.lastBracket();
    }

    protected Delimiter lastDelimiter() {
        return this.context.lastDelimiter();
    }

    protected void addBracket(Bracket bracket) {
        this.context.addBracket(bracket);
    }

    protected void removeLastBracket() {
        this.context.removeLastBracket();
    }

    protected void spnl() {
        this.context.setIndex(this.index);
        this.context.spnl();
        this.index = this.context.index();
    }

    @Nullable
    protected String match(@NonNull Pattern re) {
        this.context.setIndex(this.index);
        String result = this.context.match(re);
        this.index = this.context.index();
        return result;
    }

    @Nullable
    protected String parseLinkDestination() {
        this.context.setIndex(this.index);
        String result = this.context.parseLinkDestination();
        this.index = this.context.index();
        return result;
    }

    @Nullable
    protected String parseLinkTitle() {
        this.context.setIndex(this.index);
        String result = this.context.parseLinkTitle();
        this.index = this.context.index();
        return result;
    }

    protected int parseLinkLabel() {
        this.context.setIndex(this.index);
        int result = this.context.parseLinkLabel();
        this.index = this.context.index();
        return result;
    }

    protected void processDelimiters(Delimiter stackBottom) {
        this.context.setIndex(this.index);
        this.context.processDelimiters(stackBottom);
        this.index = this.context.index();
    }

    @NonNull
    protected Text text(@NonNull String text) {
        return this.context.text(text);
    }

    @NonNull
    protected Text text(@NonNull String text, int start, int end) {
        return this.context.text(text, start, end);
    }

    protected char peek() {
        this.context.setIndex(this.index);
        return this.context.peek();
    }
}

