/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.inlineparser;

import org.commonmark.node.Node;
import org.commonmark.node.Text;

public abstract class InlineParserUtils {
    public static void mergeTextNodesBetweenExclusive(Node fromNode, Node toNode) {
        if (fromNode == toNode || fromNode.getNext() == toNode) {
            return;
        }
        InlineParserUtils.mergeTextNodesInclusive(fromNode.getNext(), toNode.getPrevious());
    }

    public static void mergeChildTextNodes(Node node) {
        if (node.getFirstChild() == node.getLastChild()) {
            return;
        }
        InlineParserUtils.mergeTextNodesInclusive(node.getFirstChild(), node.getLastChild());
    }

    public static void mergeTextNodesInclusive(Node fromNode, Node toNode) {
        Text first = null;
        Text last = null;
        int length = 0;
        for (Node node = fromNode; node != null; node = node.getNext()) {
            if (node instanceof Text) {
                Text text = (Text)node;
                if (first == null) {
                    first = text;
                }
                length += text.getLiteral().length();
                last = text;
            } else {
                InlineParserUtils.mergeIfNeeded(first, last, length);
                first = null;
                last = null;
                length = 0;
            }
            if (node == toNode) break;
        }
        InlineParserUtils.mergeIfNeeded(first, last, length);
    }

    public static void mergeIfNeeded(Text first, Text last, int textLength) {
        if (first != null && last != null && first != last) {
            StringBuilder sb = new StringBuilder(textLength);
            sb.append(first.getLiteral());
            Node stop = last.getNext();
            for (Node node = first.getNext(); node != stop; node = node.getNext()) {
                sb.append(((Text)node).getLiteral());
                Node unlink = node;
                unlink.unlink();
            }
            String literal = sb.toString();
            first.setLiteral(literal);
        }
    }

    private InlineParserUtils() {
    }
}

