/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.html;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.html.HtmlTag;
import java.util.Collections;
import java.util.List;
import java.util.Map;

abstract class HtmlTagImpl
implements HtmlTag {
    final String name;
    final int start;
    final Map<String, String> attributes;
    int end = -1;

    protected HtmlTagImpl(@NonNull String name, int start, @NonNull Map<String, String> attributes) {
        this.name = name;
        this.start = start;
        this.attributes = attributes;
    }

    @Override
    @NonNull
    public String name() {
        return this.name;
    }

    @Override
    public int start() {
        return this.start;
    }

    @Override
    public int end() {
        return this.end;
    }

    @Override
    public boolean isEmpty() {
        return this.start == this.end;
    }

    @Override
    @NonNull
    public Map<String, String> attributes() {
        return this.attributes;
    }

    @Override
    public boolean isClosed() {
        return this.end > -1;
    }

    abstract void closeAt(int var1);

    static class BlockImpl
    extends HtmlTagImpl
    implements HtmlTag.Block {
        final BlockImpl parent;
        List<BlockImpl> children;

        @NonNull
        static BlockImpl root() {
            return new BlockImpl("", 0, Collections.emptyMap(), null);
        }

        @NonNull
        static BlockImpl create(@NonNull String name, int start, @NonNull Map<String, String> attributes, @Nullable BlockImpl parent) {
            return new BlockImpl(name, start, attributes, parent);
        }

        BlockImpl(@NonNull String name, int start, @NonNull Map<String, String> attributes, @Nullable BlockImpl parent) {
            super(name, start, attributes);
            this.parent = parent;
        }

        @Override
        void closeAt(int end) {
            if (!this.isClosed()) {
                this.end = end;
                if (this.children != null) {
                    for (BlockImpl child : this.children) {
                        child.closeAt(end);
                    }
                }
            }
        }

        @Override
        public boolean isRoot() {
            return this.parent == null;
        }

        @Override
        @Nullable
        public HtmlTag.Block parent() {
            return this.parent;
        }

        @Override
        @NonNull
        public List<HtmlTag.Block> children() {
            List<HtmlTag.Block> list = this.children == null ? Collections.emptyList() : Collections.unmodifiableList(this.children);
            return list;
        }

        @Override
        @NonNull
        public Map<String, String> attributes() {
            return this.attributes;
        }

        @Override
        public boolean isInline() {
            return false;
        }

        @Override
        public boolean isBlock() {
            return true;
        }

        @Override
        @NonNull
        public HtmlTag.Inline getAsInline() {
            throw new ClassCastException("Cannot cast Block instance to Inline");
        }

        @Override
        @NonNull
        public HtmlTag.Block getAsBlock() {
            return this;
        }

        public String toString() {
            return "BlockImpl{name='" + this.name + '\'' + ", start=" + this.start + ", end=" + this.end + ", attributes=" + this.attributes + ", parent=" + (this.parent != null ? this.parent.name : null) + ", children=" + this.children + '}';
        }
    }

    static class InlineImpl
    extends HtmlTagImpl
    implements HtmlTag.Inline {
        InlineImpl(@NonNull String name, int start, @NonNull Map<String, String> attributes) {
            super(name, start, attributes);
        }

        @Override
        void closeAt(int end) {
            if (!this.isClosed()) {
                this.end = end;
            }
        }

        public String toString() {
            return "InlineImpl{name='" + this.name + '\'' + ", start=" + this.start + ", end=" + this.end + ", attributes=" + this.attributes + '}';
        }

        @Override
        public boolean isInline() {
            return true;
        }

        @Override
        public boolean isBlock() {
            return false;
        }

        @Override
        @NonNull
        public HtmlTag.Inline getAsInline() {
            return this;
        }

        @Override
        @NonNull
        public HtmlTag.Block getAsBlock() {
            throw new ClassCastException("Cannot cast Inline instance to Block");
        }
    }
}

