/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.editor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;

class diff_match_patch {
    private static final Pattern BLANKLINEEND = Pattern.compile("\\n\\r?\\n\\Z", 32);
    private static final Pattern BLANKLINESTART = Pattern.compile("\\A\\r?\\n\\r?\\n", 32);

    diff_match_patch() {
    }

    static LinkedList<Diff> diff_main(String text1, String text2) {
        return diff_match_patch.diff_main(text1, text2, true);
    }

    private static LinkedList<Diff> diff_main(String text1, String text2, boolean checklines) {
        if (text1 == null || text2 == null) {
            throw new IllegalArgumentException("Null inputs. (diff_main)");
        }
        if (text1.equals(text2)) {
            LinkedList<Diff> diffs = new LinkedList<Diff>();
            if (text1.length() != 0) {
                diffs.add(new Diff(Operation.EQUAL, text1));
            }
            return diffs;
        }
        int commonlength = diff_match_patch.diff_commonPrefix(text1, text2);
        String commonprefix = text1.substring(0, commonlength);
        text1 = text1.substring(commonlength);
        text2 = text2.substring(commonlength);
        commonlength = diff_match_patch.diff_commonSuffix(text1, text2);
        String commonsuffix = text1.substring(text1.length() - commonlength);
        text1 = text1.substring(0, text1.length() - commonlength);
        text2 = text2.substring(0, text2.length() - commonlength);
        LinkedList<Diff> diffs = diff_match_patch.diff_compute(text1, text2, checklines);
        if (commonprefix.length() != 0) {
            diffs.addFirst(new Diff(Operation.EQUAL, commonprefix));
        }
        if (commonsuffix.length() != 0) {
            diffs.addLast(new Diff(Operation.EQUAL, commonsuffix));
        }
        diff_match_patch.diff_cleanupMerge(diffs);
        return diffs;
    }

    private static LinkedList<Diff> diff_compute(String text1, String text2, boolean checklines) {
        String shorttext;
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        if (text1.length() == 0) {
            diffs.add(new Diff(Operation.INSERT, text2));
            return diffs;
        }
        if (text2.length() == 0) {
            diffs.add(new Diff(Operation.DELETE, text1));
            return diffs;
        }
        String longtext = text1.length() > text2.length() ? text1 : text2;
        int i = longtext.indexOf(shorttext = text1.length() > text2.length() ? text2 : text1);
        if (i != -1) {
            Operation op = text1.length() > text2.length() ? Operation.DELETE : Operation.INSERT;
            diffs.add(new Diff(op, longtext.substring(0, i)));
            diffs.add(new Diff(Operation.EQUAL, shorttext));
            diffs.add(new Diff(op, longtext.substring(i + shorttext.length())));
            return diffs;
        }
        if (shorttext.length() == 1) {
            diffs.add(new Diff(Operation.DELETE, text1));
            diffs.add(new Diff(Operation.INSERT, text2));
            return diffs;
        }
        String[] hm = diff_match_patch.diff_halfMatch(text1, text2);
        if (hm != null) {
            String text1_a = hm[0];
            String text1_b = hm[1];
            String text2_a = hm[2];
            String text2_b = hm[3];
            String mid_common = hm[4];
            LinkedList<Diff> diffs_a = diff_match_patch.diff_main(text1_a, text2_a, checklines);
            LinkedList<Diff> diffs_b = diff_match_patch.diff_main(text1_b, text2_b, checklines);
            diffs = diffs_a;
            diffs.add(new Diff(Operation.EQUAL, mid_common));
            diffs.addAll(diffs_b);
            return diffs;
        }
        if (checklines && text1.length() > 100 && text2.length() > 100) {
            return diff_match_patch.diff_lineMode(text1, text2);
        }
        return diff_match_patch.diff_bisect(text1, text2);
    }

    private static LinkedList<Diff> diff_lineMode(String text1, String text2) {
        LinesToCharsResult a = diff_match_patch.diff_linesToChars(text1, text2);
        text1 = a.chars1;
        text2 = a.chars2;
        List<String> linearray = a.lineArray;
        LinkedList<Diff> diffs = diff_match_patch.diff_main(text1, text2, false);
        diff_match_patch.diff_charsToLines(diffs, linearray);
        diff_match_patch.diff_cleanupSemantic(diffs);
        diffs.add(new Diff(Operation.EQUAL, ""));
        int count_delete = 0;
        int count_insert = 0;
        String text_delete = "";
        String text_insert = "";
        ListIterator<Diff> pointer = diffs.listIterator();
        Diff thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            switch (thisDiff.operation) {
                case INSERT: {
                    ++count_insert;
                    text_insert = text_insert + thisDiff.text;
                    break;
                }
                case DELETE: {
                    ++count_delete;
                    text_delete = text_delete + thisDiff.text;
                    break;
                }
                case EQUAL: {
                    if (count_delete >= 1 && count_insert >= 1) {
                        pointer.previous();
                        for (int j = 0; j < count_delete + count_insert; ++j) {
                            pointer.previous();
                            pointer.remove();
                        }
                        for (Diff subDiff : diff_match_patch.diff_main(text_delete, text_insert, false)) {
                            pointer.add(subDiff);
                        }
                    }
                    count_insert = 0;
                    count_delete = 0;
                    text_delete = "";
                    text_insert = "";
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        diffs.removeLast();
        return diffs;
    }

    private static LinkedList<Diff> diff_bisect(String text1, String text2) {
        int max_d;
        int text1_length = text1.length();
        int text2_length = text2.length();
        int v_offset = max_d = (text1_length + text2_length + 1) / 2;
        int v_length = 2 * max_d;
        int[] v1 = new int[v_length];
        int[] v2 = new int[v_length];
        for (int x = 0; x < v_length; ++x) {
            v1[x] = -1;
            v2[x] = -1;
        }
        v1[v_offset + 1] = 0;
        v2[v_offset + 1] = 0;
        int delta = text1_length - text2_length;
        boolean front = delta % 2 != 0;
        int k1start = 0;
        int k1end = 0;
        int k2start = 0;
        int k2end = 0;
        for (int d = 0; d < max_d; ++d) {
            for (int k1 = -d + k1start; k1 <= d - k1end; k1 += 2) {
                int x2;
                int k2_offset;
                int y1;
                int k1_offset = v_offset + k1;
                int x1 = k1 == -d || k1 != d && v1[k1_offset - 1] < v1[k1_offset + 1] ? v1[k1_offset + 1] : v1[k1_offset - 1] + 1;
                for (y1 = x1 - k1; x1 < text1_length && y1 < text2_length && text1.charAt(x1) == text2.charAt(y1); ++x1, ++y1) {
                }
                v1[k1_offset] = x1;
                if (x1 > text1_length) {
                    k1end += 2;
                    continue;
                }
                if (y1 > text2_length) {
                    k1start += 2;
                    continue;
                }
                if (!front || (k2_offset = v_offset + delta - k1) < 0 || k2_offset >= v_length || v2[k2_offset] == -1 || x1 < (x2 = text1_length - v2[k2_offset])) continue;
                return diff_match_patch.diff_bisectSplit(text1, text2, x1, y1);
            }
            for (int k2 = -d + k2start; k2 <= d - k2end; k2 += 2) {
                int k1_offset;
                int y2;
                int k2_offset = v_offset + k2;
                int x2 = k2 == -d || k2 != d && v2[k2_offset - 1] < v2[k2_offset + 1] ? v2[k2_offset + 1] : v2[k2_offset - 1] + 1;
                for (y2 = x2 - k2; x2 < text1_length && y2 < text2_length && text1.charAt(text1_length - x2 - 1) == text2.charAt(text2_length - y2 - 1); ++x2, ++y2) {
                }
                v2[k2_offset] = x2;
                if (x2 > text1_length) {
                    k2end += 2;
                    continue;
                }
                if (y2 > text2_length) {
                    k2start += 2;
                    continue;
                }
                if (front || (k1_offset = v_offset + delta - k2) < 0 || k1_offset >= v_length || v1[k1_offset] == -1) continue;
                int x1 = v1[k1_offset];
                int y1 = v_offset + x1 - k1_offset;
                if (x1 < (x2 = text1_length - x2)) continue;
                return diff_match_patch.diff_bisectSplit(text1, text2, x1, y1);
            }
        }
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        diffs.add(new Diff(Operation.DELETE, text1));
        diffs.add(new Diff(Operation.INSERT, text2));
        return diffs;
    }

    private static LinkedList<Diff> diff_bisectSplit(String text1, String text2, int x, int y) {
        String text1a = text1.substring(0, x);
        String text2a = text2.substring(0, y);
        String text1b = text1.substring(x);
        String text2b = text2.substring(y);
        LinkedList<Diff> diffs = diff_match_patch.diff_main(text1a, text2a, false);
        LinkedList<Diff> diffsb = diff_match_patch.diff_main(text1b, text2b, false);
        diffs.addAll(diffsb);
        return diffs;
    }

    private static LinesToCharsResult diff_linesToChars(String text1, String text2) {
        ArrayList<String> lineArray = new ArrayList<String>();
        HashMap<String, Integer> lineHash = new HashMap<String, Integer>();
        lineArray.add("");
        String chars1 = diff_match_patch.diff_linesToCharsMunge(text1, lineArray, lineHash, 40000);
        String chars2 = diff_match_patch.diff_linesToCharsMunge(text2, lineArray, lineHash, 65535);
        return new LinesToCharsResult(chars1, chars2, lineArray);
    }

    private static String diff_linesToCharsMunge(String text, List<String> lineArray, Map<String, Integer> lineHash, int maxLines) {
        int lineStart = 0;
        int lineEnd = -1;
        StringBuilder chars = new StringBuilder();
        while (lineEnd < text.length() - 1) {
            String line;
            lineEnd = text.indexOf(10, lineStart);
            if (lineEnd == -1) {
                lineEnd = text.length() - 1;
            }
            if (lineHash.containsKey(line = text.substring(lineStart, lineEnd + 1))) {
                chars.append(String.valueOf((char)lineHash.get(line).intValue()));
            } else {
                if (lineArray.size() == maxLines) {
                    line = text.substring(lineStart);
                    lineEnd = text.length();
                }
                lineArray.add(line);
                lineHash.put(line, lineArray.size() - 1);
                chars.append(String.valueOf((char)(lineArray.size() - 1)));
            }
            lineStart = lineEnd + 1;
        }
        return chars.toString();
    }

    private static void diff_charsToLines(List<Diff> diffs, List<String> lineArray) {
        for (Diff diff : diffs) {
            StringBuilder text = new StringBuilder();
            for (int j = 0; j < diff.text.length(); ++j) {
                text.append(lineArray.get(diff.text.charAt(j)));
            }
            diff.text = text.toString();
        }
    }

    public static int diff_commonPrefix(String text1, String text2) {
        int n = Math.min(text1.length(), text2.length());
        for (int i = 0; i < n; ++i) {
            if (text1.charAt(i) == text2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    private static int diff_commonSuffix(String text1, String text2) {
        int text1_length = text1.length();
        int text2_length = text2.length();
        int n = Math.min(text1_length, text2_length);
        for (int i = 1; i <= n; ++i) {
            if (text1.charAt(text1_length - i) == text2.charAt(text2_length - i)) continue;
            return i - 1;
        }
        return n;
    }

    private static int diff_commonOverlap(String text1, String text2) {
        int text1_length = text1.length();
        int text2_length = text2.length();
        if (text1_length == 0 || text2_length == 0) {
            return 0;
        }
        if (text1_length > text2_length) {
            text1 = text1.substring(text1_length - text2_length);
        } else if (text1_length < text2_length) {
            text2 = text2.substring(0, text1_length);
        }
        int text_length = Math.min(text1_length, text2_length);
        if (text1.equals(text2)) {
            return text_length;
        }
        int best = 0;
        int length = 1;
        String pattern;
        int found;
        while ((found = text2.indexOf(pattern = text1.substring(text_length - length))) != -1) {
            if (found != 0 && !text1.substring(text_length - (length += found)).equals(text2.substring(0, length))) continue;
            best = length++;
        }
        return best;
    }

    private static String[] diff_halfMatch(String text1, String text2) {
        String[] hm;
        String shorttext;
        String longtext = text1.length() > text2.length() ? text1 : text2;
        String string = shorttext = text1.length() > text2.length() ? text2 : text1;
        if (longtext.length() < 4 || shorttext.length() * 2 < longtext.length()) {
            return null;
        }
        String[] hm1 = diff_match_patch.diff_halfMatchI(longtext, shorttext, (longtext.length() + 3) / 4);
        String[] hm2 = diff_match_patch.diff_halfMatchI(longtext, shorttext, (longtext.length() + 1) / 2);
        if (hm1 == null && hm2 == null) {
            return null;
        }
        if (hm2 == null) {
            hm = hm1;
        } else if (hm1 == null) {
            hm = hm2;
        } else {
            String[] stringArray = hm = hm1[4].length() > hm2[4].length() ? hm1 : hm2;
        }
        if (text1.length() > text2.length()) {
            return hm;
        }
        return new String[]{hm[2], hm[3], hm[0], hm[1], hm[4]};
    }

    private static String[] diff_halfMatchI(String longtext, String shorttext, int i) {
        String seed = longtext.substring(i, i + longtext.length() / 4);
        int j = -1;
        String best_common = "";
        String best_longtext_a = "";
        String best_longtext_b = "";
        String best_shorttext_a = "";
        String best_shorttext_b = "";
        while ((j = shorttext.indexOf(seed, j + 1)) != -1) {
            int prefixLength = diff_match_patch.diff_commonPrefix(longtext.substring(i), shorttext.substring(j));
            int suffixLength = diff_match_patch.diff_commonSuffix(longtext.substring(0, i), shorttext.substring(0, j));
            if (best_common.length() >= suffixLength + prefixLength) continue;
            best_common = shorttext.substring(j - suffixLength, j) + shorttext.substring(j, j + prefixLength);
            best_longtext_a = longtext.substring(0, i - suffixLength);
            best_longtext_b = longtext.substring(i + prefixLength);
            best_shorttext_a = shorttext.substring(0, j - suffixLength);
            best_shorttext_b = shorttext.substring(j + prefixLength);
        }
        if (best_common.length() * 2 >= longtext.length()) {
            return new String[]{best_longtext_a, best_longtext_b, best_shorttext_a, best_shorttext_b, best_common};
        }
        return null;
    }

    private static void diff_cleanupSemantic(LinkedList<Diff> diffs) {
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        ArrayDeque<Diff> equalities = new ArrayDeque<Diff>();
        String lastEquality = null;
        ListIterator<Diff> pointer = diffs.listIterator();
        int length_insertions1 = 0;
        int length_deletions1 = 0;
        int length_insertions2 = 0;
        int length_deletions2 = 0;
        Diff thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            if (thisDiff.operation == Operation.EQUAL) {
                equalities.push(thisDiff);
                length_insertions1 = length_insertions2;
                length_deletions1 = length_deletions2;
                length_insertions2 = 0;
                length_deletions2 = 0;
                lastEquality = thisDiff.text;
            } else {
                if (thisDiff.operation == Operation.INSERT) {
                    length_insertions2 += thisDiff.text.length();
                } else {
                    length_deletions2 += thisDiff.text.length();
                }
                if (lastEquality != null && lastEquality.length() <= Math.max(length_insertions1, length_deletions1) && lastEquality.length() <= Math.max(length_insertions2, length_deletions2)) {
                    while (thisDiff != equalities.peek()) {
                        thisDiff = (Diff)pointer.previous();
                    }
                    pointer.next();
                    pointer.set(new Diff(Operation.DELETE, lastEquality));
                    pointer.add(new Diff(Operation.INSERT, lastEquality));
                    equalities.pop();
                    if (!equalities.isEmpty()) {
                        equalities.pop();
                    }
                    if (equalities.isEmpty()) {
                        while (pointer.hasPrevious()) {
                            pointer.previous();
                        }
                    } else {
                        thisDiff = (Diff)equalities.peek();
                        while (thisDiff != pointer.previous()) {
                        }
                    }
                    length_insertions1 = 0;
                    length_insertions2 = 0;
                    length_deletions1 = 0;
                    length_deletions2 = 0;
                    lastEquality = null;
                    changes = true;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            diff_match_patch.diff_cleanupMerge(diffs);
        }
        diff_match_patch.diff_cleanupSemanticLossless(diffs);
        pointer = diffs.listIterator();
        Diff prevDiff = null;
        thisDiff = null;
        if (pointer.hasNext()) {
            prevDiff = (Diff)pointer.next();
            if (pointer.hasNext()) {
                thisDiff = (Diff)pointer.next();
            }
        }
        while (thisDiff != null) {
            if (prevDiff.operation == Operation.DELETE && thisDiff.operation == Operation.INSERT) {
                int overlap_length2;
                String deletion = prevDiff.text;
                String insertion = thisDiff.text;
                int overlap_length1 = diff_match_patch.diff_commonOverlap(deletion, insertion);
                if (overlap_length1 >= (overlap_length2 = diff_match_patch.diff_commonOverlap(insertion, deletion))) {
                    if ((double)overlap_length1 >= (double)deletion.length() / 2.0 || (double)overlap_length1 >= (double)insertion.length() / 2.0) {
                        pointer.previous();
                        pointer.add(new Diff(Operation.EQUAL, insertion.substring(0, overlap_length1)));
                        prevDiff.text = deletion.substring(0, deletion.length() - overlap_length1);
                        thisDiff.text = insertion.substring(overlap_length1);
                    }
                } else if ((double)overlap_length2 >= (double)deletion.length() / 2.0 || (double)overlap_length2 >= (double)insertion.length() / 2.0) {
                    pointer.previous();
                    pointer.add(new Diff(Operation.EQUAL, deletion.substring(0, overlap_length2)));
                    prevDiff.operation = Operation.INSERT;
                    prevDiff.text = insertion.substring(0, insertion.length() - overlap_length2);
                    thisDiff.operation = Operation.DELETE;
                    thisDiff.text = deletion.substring(overlap_length2);
                }
                thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
            }
            prevDiff = thisDiff;
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
    }

    private static void diff_cleanupSemanticLossless(LinkedList<Diff> diffs) {
        Diff nextDiff;
        ListIterator pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff diff = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            if (prevDiff.operation == Operation.EQUAL && nextDiff.operation == Operation.EQUAL) {
                String equality1 = prevDiff.text;
                String edit = thisDiff.text;
                String equality2 = nextDiff.text;
                int commonOffset = diff_match_patch.diff_commonSuffix(equality1, edit);
                if (commonOffset != 0) {
                    String commonString = edit.substring(edit.length() - commonOffset);
                    equality1 = equality1.substring(0, equality1.length() - commonOffset);
                    edit = commonString + edit.substring(0, edit.length() - commonOffset);
                    equality2 = commonString + equality2;
                }
                String bestEquality1 = equality1;
                String bestEdit = edit;
                String bestEquality2 = equality2;
                int bestScore = diff_match_patch.diff_cleanupSemanticScore(equality1, edit) + diff_match_patch.diff_cleanupSemanticScore(edit, equality2);
                while (edit.length() != 0 && equality2.length() != 0 && edit.charAt(0) == equality2.charAt(0)) {
                    equality1 = equality1 + edit.charAt(0);
                    edit = edit.substring(1) + equality2.charAt(0);
                    equality2 = equality2.substring(1);
                    int score = diff_match_patch.diff_cleanupSemanticScore(equality1, edit) + diff_match_patch.diff_cleanupSemanticScore(edit, equality2);
                    if (score < bestScore) continue;
                    bestScore = score;
                    bestEquality1 = equality1;
                    bestEdit = edit;
                    bestEquality2 = equality2;
                }
                if (!prevDiff.text.equals(bestEquality1)) {
                    if (bestEquality1.length() != 0) {
                        prevDiff.text = bestEquality1;
                    } else {
                        pointer.previous();
                        pointer.previous();
                        pointer.previous();
                        pointer.remove();
                        pointer.next();
                        pointer.next();
                    }
                    thisDiff.text = bestEdit;
                    if (bestEquality2.length() != 0) {
                        nextDiff.text = bestEquality2;
                    } else {
                        pointer.remove();
                        nextDiff = thisDiff;
                        thisDiff = prevDiff;
                    }
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
    }

    private static int diff_cleanupSemanticScore(String one, String two) {
        boolean blankLine2;
        if (one.length() == 0 || two.length() == 0) {
            return 6;
        }
        char char1 = one.charAt(one.length() - 1);
        char char2 = two.charAt(0);
        boolean nonAlphaNumeric1 = !Character.isLetterOrDigit(char1);
        boolean nonAlphaNumeric2 = !Character.isLetterOrDigit(char2);
        boolean whitespace1 = nonAlphaNumeric1 && Character.isWhitespace(char1);
        boolean whitespace2 = nonAlphaNumeric2 && Character.isWhitespace(char2);
        boolean lineBreak1 = whitespace1 && Character.getType(char1) == 15;
        boolean lineBreak2 = whitespace2 && Character.getType(char2) == 15;
        boolean blankLine1 = lineBreak1 && BLANKLINEEND.matcher(one).find();
        boolean bl = blankLine2 = lineBreak2 && BLANKLINESTART.matcher(two).find();
        if (blankLine1 || blankLine2) {
            return 5;
        }
        if (lineBreak1 || lineBreak2) {
            return 4;
        }
        if (nonAlphaNumeric1 && !whitespace1 && whitespace2) {
            return 3;
        }
        if (whitespace1 || whitespace2) {
            return 2;
        }
        if (nonAlphaNumeric1 || nonAlphaNumeric2) {
            return 1;
        }
        return 0;
    }

    private static void diff_cleanupMerge(LinkedList<Diff> diffs) {
        Diff nextDiff;
        diffs.add(new Diff(Operation.EQUAL, ""));
        ListIterator<Diff> pointer = diffs.listIterator();
        int count_delete = 0;
        int count_insert = 0;
        String text_delete = "";
        String text_insert = "";
        Diff thisDiff = (Diff)pointer.next();
        Diff prevEqual = null;
        while (thisDiff != null) {
            switch (thisDiff.operation) {
                case INSERT: {
                    ++count_insert;
                    text_insert = text_insert + thisDiff.text;
                    prevEqual = null;
                    break;
                }
                case DELETE: {
                    ++count_delete;
                    text_delete = text_delete + thisDiff.text;
                    prevEqual = null;
                    break;
                }
                case EQUAL: {
                    if (count_delete + count_insert > 1) {
                        boolean both_types = count_delete != 0 && count_insert != 0;
                        pointer.previous();
                        while (count_delete-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        while (count_insert-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        if (both_types) {
                            int commonlength = diff_match_patch.diff_commonPrefix(text_insert, text_delete);
                            if (commonlength != 0) {
                                if (pointer.hasPrevious()) {
                                    thisDiff = (Diff)pointer.previous();
                                    assert (thisDiff.operation == Operation.EQUAL) : "Previous diff should have been an equality.";
                                    thisDiff.text = thisDiff.text + text_insert.substring(0, commonlength);
                                    pointer.next();
                                } else {
                                    pointer.add(new Diff(Operation.EQUAL, text_insert.substring(0, commonlength)));
                                }
                                text_insert = text_insert.substring(commonlength);
                                text_delete = text_delete.substring(commonlength);
                            }
                            if ((commonlength = diff_match_patch.diff_commonSuffix(text_insert, text_delete)) != 0) {
                                thisDiff = (Diff)pointer.next();
                                thisDiff.text = text_insert.substring(text_insert.length() - commonlength) + thisDiff.text;
                                text_insert = text_insert.substring(0, text_insert.length() - commonlength);
                                text_delete = text_delete.substring(0, text_delete.length() - commonlength);
                                pointer.previous();
                            }
                        }
                        if (text_delete.length() != 0) {
                            pointer.add(new Diff(Operation.DELETE, text_delete));
                        }
                        if (text_insert.length() != 0) {
                            pointer.add(new Diff(Operation.INSERT, text_insert));
                        }
                        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    } else if (prevEqual != null) {
                        prevEqual.text = prevEqual.text + thisDiff.text;
                        pointer.remove();
                        thisDiff = (Diff)pointer.previous();
                        pointer.next();
                    }
                    count_insert = 0;
                    count_delete = 0;
                    text_delete = "";
                    text_insert = "";
                    prevEqual = thisDiff;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (diffs.getLast().text.length() == 0) {
            diffs.removeLast();
        }
        boolean changes = false;
        pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff diff = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            if (prevDiff.operation == Operation.EQUAL && nextDiff.operation == Operation.EQUAL) {
                if (thisDiff.text.endsWith(prevDiff.text)) {
                    thisDiff.text = prevDiff.text + thisDiff.text.substring(0, thisDiff.text.length() - prevDiff.text.length());
                    nextDiff.text = prevDiff.text + nextDiff.text;
                    pointer.previous();
                    pointer.previous();
                    pointer.previous();
                    pointer.remove();
                    pointer.next();
                    thisDiff = (Diff)pointer.next();
                    nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    changes = true;
                } else if (thisDiff.text.startsWith(nextDiff.text)) {
                    prevDiff.text = prevDiff.text + nextDiff.text;
                    thisDiff.text = thisDiff.text.substring(nextDiff.text.length()) + nextDiff.text;
                    pointer.remove();
                    nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    changes = true;
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            diff_match_patch.diff_cleanupMerge(diffs);
        }
    }

    public static class Diff {
        public Operation operation;
        public String text;

        public Diff(Operation operation, String text) {
            this.operation = operation;
            this.text = text;
        }

        public String toString() {
            String prettyText = this.text.replace('\n', '\u00b6');
            return "Diff(" + (Object)((Object)this.operation) + ",\"" + prettyText + "\")";
        }

        public int hashCode() {
            int prime = 31;
            int result = this.operation == null ? 0 : this.operation.hashCode();
            return result += 31 * (this.text == null ? 0 : this.text.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Diff other = (Diff)obj;
            if (this.operation != other.operation) {
                return false;
            }
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }
    }

    public static enum Operation {
        DELETE,
        INSERT,
        EQUAL;

    }

    protected static class LinesToCharsResult {
        protected String chars1;
        protected String chars2;
        protected List<String> lineArray;

        protected LinesToCharsResult(String chars1, String chars2, List<String> lineArray) {
            this.chars1 = chars1;
            this.chars2 = chars2;
            this.lineArray = lineArray;
        }
    }
}

