/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.editor;

import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.editor.MarkwonEditor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public abstract class MarkwonEditorTextWatcher
implements TextWatcher {
    @NonNull
    public static MarkwonEditorTextWatcher withProcess(@NonNull MarkwonEditor editor) {
        return new WithProcess(editor);
    }

    @NonNull
    public static MarkwonEditorTextWatcher withPreRender(@NonNull MarkwonEditor editor, @NonNull ExecutorService executorService, @NonNull EditText editText) {
        return new WithPreRender(editor, executorService, editText);
    }

    public abstract void afterTextChanged(Editable var1);

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    static class WithPreRender
    extends MarkwonEditorTextWatcher {
        private final MarkwonEditor editor;
        private final ExecutorService executorService;
        private int generator;
        @Nullable
        private EditText editText;
        private Future<?> future;
        private boolean selfChange;

        WithPreRender(@NonNull MarkwonEditor editor, @NonNull ExecutorService executorService, @NonNull EditText editText) {
            this.editor = editor;
            this.executorService = executorService;
            this.editText = editText;
            this.editText.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                }

                public void onViewDetachedFromWindow(View v) {
                    WithPreRender.this.editText = null;
                }
            });
        }

        @Override
        public void afterTextChanged(Editable s) {
            if (this.selfChange) {
                return;
            }
            final int key = ++this.generator;
            if (this.future != null) {
                this.future.cancel(true);
            }
            final SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)s);
            this.future = this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            WithPreRender.this.editor.preRender((Editable)builder, new MarkwonEditor.PreRenderResultListener(){

                                @Override
                                public void onPreRenderResult(final @NonNull MarkwonEditor.PreRenderResult result) {
                                    EditText et = WithPreRender.this.editText;
                                    if (et != null) {
                                        et.post(new Runnable(){

                                            @Override
                                            public void run() {
                                                EditText et;
                                                if (key == WithPreRender.this.generator && (et = WithPreRender.this.editText) != null) {
                                                    WithPreRender.this.selfChange = true;
                                                    try {
                                                        result.dispatchTo(WithPreRender.this.editText.getText());
                                                    }
                                                    finally {
                                                        WithPreRender.this.selfChange = false;
                                                    }
                                                }
                                            }
                                        });
                                    }
                                }
                            });
                        }
                        catch (Throwable t) {
                            EditText et = WithPreRender.this.editText;
                            if (et == null) break block2;
                            et.post(new Runnable(){

                                @Override
                                public void run() {
                                    throw new RuntimeException(t);
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    static class WithProcess
    extends MarkwonEditorTextWatcher {
        private final MarkwonEditor editor;
        private boolean selfChange;

        WithProcess(@NonNull MarkwonEditor editor) {
            this.editor = editor;
        }

        @Override
        public void afterTextChanged(Editable s) {
            if (this.selfChange) {
                return;
            }
            this.selfChange = true;
            try {
                this.editor.process(s);
            }
            finally {
                this.selfChange = false;
            }
        }
    }
}

