/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.compose.rules;

import io.nlopez.compose.core.ComposeKtConfig;
import io.nlopez.compose.core.ComposeKtVisitor;
import io.nlopez.compose.core.Emitter;
import io.nlopez.compose.core.EmitterKt;
import io.nlopez.compose.core.util.LambdasKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lio/nlopez/compose/rules/ParameterNaming;", "Lio/nlopez/compose/core/ComposeKtVisitor;", "<init>", "()V", "visitComposable", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "emitter", "Lio/nlopez/compose/core/Emitter;", "config", "Lio/nlopez/compose/core/ComposeKtConfig;", "isPastTense", "", "", "(Ljava/lang/String;)Z", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nParameterNaming.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParameterNaming.kt\nio/nlopez/compose/rules/ParameterNaming\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n774#2:243\n865#2,2:244\n774#2:246\n865#2,2:247\n827#2:249\n855#2,2:250\n774#2:252\n865#2,2:253\n2632#2,3:255\n1755#2,3:258\n*S KotlinDebug\n*F\n+ 1 ParameterNaming.kt\nio/nlopez/compose/rules/ParameterNaming\n*L\n22#1:243\n22#1:244,2\n23#1:246\n23#1:247,2\n28#1:249\n28#1:250,2\n29#1:252\n29#1:253,2\n37#1:255,3\n38#1:258,3\n*E\n"})
public final class ParameterNaming
implements ComposeKtVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Set<String>> IrregularVerbsInPastTense$delegate = LazyKt.lazy(ParameterNaming::IrregularVerbsInPastTense_delegate$lambda$6);
    @NotNull
    private static final Lazy<Set<String>> VerbsPresentTenseEndingInEd$delegate = LazyKt.lazy(ParameterNaming::VerbsPresentTenseEndingInEd_delegate$lambda$7);
    @NotNull
    private static final Lazy<Set<String>> ExceptionsInCompose$delegate = LazyKt.lazy(ParameterNaming::ExceptionsInCompose_delegate$lambda$8);
    @NotNull
    private static final String LambdaParametersInPresentTense = "Lambda parameters in a composable function should be in present tense, not past tense.\nExamples: `onClick` and not `onClicked`, `onTextChange` and not `onTextChanged`, etc.\nSee https://mrmans0n.github.io/compose-rules/rules/#naming-parameters-properly for more information.";

    @Override
    public void visitComposable(@NotNull KtFunction function, @NotNull Emitter emitter, @NotNull ComposeKtConfig config) {
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        KtParameter it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        KtFile ktFile = function.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        Set<String> lambdaTypes = LambdasKt.lambdaTypes(ktFile, config);
        List list = function.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtParameter)element$iv$iv;
            boolean bl = false;
            KtTypeReference ktTypeReference = it.getTypeReference();
            boolean bl2 = ktTypeReference != null ? LambdasKt.isLambda(ktTypeReference, lambdaTypes) : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtParameter)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            boolean bl3 = string != null ? StringsKt.startsWith$default((String)string, (String)"on", (boolean)false, (int)2, null) : false;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (KtParameter)element$iv$iv;
            boolean bl = false;
            if (CollectionsKt.contains((Iterable)ParameterNaming.Companion.getExceptionsInCompose(), (Object)it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtParameter)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            boolean bl4 = string != null ? this.isPastTense(string) : false;
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List errors = (List)destination$iv$iv;
        for (KtParameter error : errors) {
            Intrinsics.checkNotNull((Object)error);
            EmitterKt.report(emitter, (PsiElement)error, LambdaParametersInPresentTense);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPastTense(String $this$isPastTense) {
        String it;
        boolean bl;
        Iterable $this$none$iv = ParameterNaming.Companion.getVerbsPresentTenseEndingInEd();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$none$iv) {
                it = (String)element$iv;
                boolean bl2 = false;
                if (!StringsKt.endsWith$default((String)$this$isPastTense, (String)it, (boolean)false, (int)2, null)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (StringsKt.endsWith$default((String)$this$isPastTense, (String)"ed", (boolean)false, (int)2, null)) return true;
        Iterable $this$any$iv = ParameterNaming.Companion.getIrregularVerbsInPastTense();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl3 = false;
        } while (!StringsKt.endsWith$default((String)$this$isPastTense, (String)it, (boolean)false, (int)2, null));
        return true;
    }

    private static final Set IrregularVerbsInPastTense_delegate$lambda$6() {
        Object[] objectArray = new String[]{"Arose", "Arisen", "Ate", "Awoke", "Awoken", "Beaten", "Became", "Been", "Began", "Begun", "Bent", "Bit", "Bitten", "Bled", "Blew", "Blown", "Bore", "Borne", "Bought", "Bound", "Bred", "Broke", "Broken", "Brought", "Built", "Burnt", "Burst", "Came", "Caught", "Chose", "Chosen", "Clung", "Crept", "Dealt", "Did", "Done", "Drank", "Drawn", "Dreamt", "Drew", "Driven", "Drove", "Drunk", "Eaten", "Fallen", "Fed", "Felt", "Fled", "Flew", "Flown", "Forbade", "Forbidden", "Forgave", "Forgiven", "Forgot", "Forgotten", "Fought", "Found", "Froze", "Frozen", "Gave", "Given", "Gone", "Got", "Gotten", "Grew", "Grown", "Had", "Heard", "Held", "Hid", "Hidden", "Hung", "Kept", "Knew", "Known", "Laid", "Lain", "Lay", "Led", "Lent", "Lit", "Lost", "Made", "Meant", "Met", "Paid", "Ran", "Rang", "Ridden", "Risen", "Rode", "Rose", "Rung", "Said", "Sang", "Sank", "Sat", "Saw", "Seen", "Sent", "Shaken", "Shone", "Shook", "Shot", "Showed", "Shown", "Shrank", "Shrunk", "Slept", "Slid", "Sold", "Sought", "Spent", "Spoke", "Spoken", "Sprang", "Sprung", "Spun", "Stole", "Stolen", "Stood", "Struck", "Stuck", "Stung", "Sung", "Sunk", "Swam", "Swept", "Swore", "Sworn", "Swum", "Swung", "Taken", "Taught", "Thought", "Threw", "Thrown", "Told", "Took", "Tore", "Torn", "Understood", "Was", "Went", "Were", "Woke", "Woken", "Won", "Wore", "Worn", "Wound", "Written", "Wrote"};
        return SetsKt.setOf((Object[])objectArray);
    }

    private static final Set VerbsPresentTenseEndingInEd_delegate$lambda$7() {
        Object[] objectArray = new String[]{"Bed", "Bleed", "Embed", "Exceed", "Feed", "Heed", "Need", "Proceed", "Seed", "Shed", "Shred", "Sled", "Speed", "Succeed", "Wed", "Weed"};
        return SetsKt.setOf((Object[])objectArray);
    }

    private static final Set ExceptionsInCompose_delegate$lambda$8() {
        Object[] objectArray = new String[]{"onFocusChanged", "onValueChangeFinished"};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lio/nlopez/compose/rules/ParameterNaming$Companion;", "", "<init>", "()V", "IrregularVerbsInPastTense", "", "", "getIrregularVerbsInPastTense", "()Ljava/util/Set;", "IrregularVerbsInPastTense$delegate", "Lkotlin/Lazy;", "VerbsPresentTenseEndingInEd", "getVerbsPresentTenseEndingInEd", "VerbsPresentTenseEndingInEd$delegate", "ExceptionsInCompose", "getExceptionsInCompose", "ExceptionsInCompose$delegate", "LambdaParametersInPresentTense", "getLambdaParametersInPresentTense", "()Ljava/lang/String;", "common"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<String> getIrregularVerbsInPastTense() {
            Lazy lazy = IrregularVerbsInPastTense$delegate;
            return (Set)lazy.getValue();
        }

        private final Set<String> getVerbsPresentTenseEndingInEd() {
            Lazy lazy = VerbsPresentTenseEndingInEd$delegate;
            return (Set)lazy.getValue();
        }

        private final Set<String> getExceptionsInCompose() {
            Lazy lazy = ExceptionsInCompose$delegate;
            return (Set)lazy.getValue();
        }

        @NotNull
        public final String getLambdaParametersInPresentTense() {
            return LambdaParametersInPresentTense;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

