/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.wire;

import io.nextop.Wire;
import io.nextop.log.NL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.functions.Action0;

public class Throttle
implements Wire.Adapter {
    private final Object mutex = new Object();
    private final Scheduler scheduler;
    private final Scheduler.Worker worker;
    private List<Wire> active;
    private boolean online = true;
    final Action0 ONLINE = new Action0(){

        public void call() {
            Throttle.this.online();
        }
    };
    final Action0 OFFLINE = new Action0(){

        public void call() {
            Throttle.this.offline();
        }
    };

    public Throttle(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.worker = scheduler.createWorker();
        this.active = new ArrayList<Wire>(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void online() {
        Object object = this.mutex;
        synchronized (object) {
            this.online = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offline() {
        List<Wire> drop;
        Iterator<Wire> iterator = this.mutex;
        synchronized (iterator) {
            if (this.online) {
                this.online = false;
                drop = this.active;
                this.active = new ArrayList<Wire>(4);
            } else {
                drop = null;
            }
        }
        if (null != drop) {
            for (Wire wire : drop) {
                try {
                    wire.close();
                }
                catch (IOException e) {
                    NL.nl.handled("wire.throttle", e);
                }
            }
        }
    }

    public void online(int timeout, TimeUnit timeUnit) {
        if (timeout <= 0) {
            this.online();
        } else {
            this.worker.schedule(this.ONLINE, (long)timeout, timeUnit);
        }
    }

    public void offline(int timeout, TimeUnit timeUnit) {
        if (timeout <= 0) {
            this.offline();
        } else {
            this.worker.schedule(this.OFFLINE, (long)timeout, timeUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addActive(Wire wire) {
        Object object = this.mutex;
        synchronized (object) {
            this.active.add(wire);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeActive(Wire wire) {
        Object object = this.mutex;
        synchronized (object) {
            this.active.remove(wire);
        }
    }

    @Override
    public Wire adapt(Wire wire) throws InterruptedException, NoSuchElementException {
        ThrottledWire tw = new ThrottledWire(wire);
        this.addActive(tw);
        return tw;
    }

    final class ThrottledWire
    implements Wire {
        final Wire impl;

        ThrottledWire(Wire impl) {
            this.impl = impl;
        }

        void destroy() {
            Throttle.this.removeActive(this);
        }

        @Override
        public void close() throws IOException {
            try {
                this.impl.close();
            }
            finally {
                this.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read(byte[] buffer, int offset, int length, int messageBoundary) throws IOException {
            try {
                this.impl.read(buffer, offset, length, messageBoundary);
            }
            finally {
                this.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skip(long n, int messageBoundary) throws IOException {
            try {
                this.impl.skip(n, messageBoundary);
            }
            finally {
                this.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buffer, int offset, int length, int messageBoundary) throws IOException {
            try {
                this.impl.write(buffer, offset, length, messageBoundary);
            }
            finally {
                this.destroy();
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                this.impl.flush();
            }
            finally {
                this.destroy();
            }
        }
    }
}

