/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.wire;

import io.nextop.Wire;
import io.nextop.Wires;
import java.io.IOException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import javax.annotation.Nullable;
import rx.Observable;
import rx.subjects.BehaviorSubject;

public final class Pipe {
    final Object mutex = new Object();
    final PairedWireFactory a;
    final PairedWireFactory b;
    final BehaviorSubject<Wire.Factory> aSubject = BehaviorSubject.create();
    final BehaviorSubject<Wire.Factory> bSubject = BehaviorSubject.create();

    public Pipe() {
        this.a = new PairedWireFactory(this.mutex);
        this.a.pair = this.b = new PairedWireFactory(this.mutex);
        this.a.pairSubject = this.bSubject;
        this.b.pair = this.a;
        this.b.pairSubject = this.aSubject;
    }

    public Wire.Factory getA() {
        return this.a;
    }

    public Wire.Factory getB() {
        return this.b;
    }

    public Observable<Wire.Factory> observeA() {
        return this.aSubject;
    }

    public Observable<Wire.Factory> observeB() {
        return this.bSubject;
    }

    static final class PairWire
    implements Wire {
        private final Wire in;
        private final Wire out;

        PairWire(Wire in, Wire out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void close() throws IOException {
            try {
                this.in.close();
            }
            finally {
                this.out.close();
            }
        }

        @Override
        public void read(byte[] buffer, int offset, int length, int messageBoundary) throws IOException {
            this.in.read(buffer, offset, length, messageBoundary);
        }

        @Override
        public void skip(long n, int messageBoundary) throws IOException {
            this.in.skip(n, messageBoundary);
        }

        @Override
        public void write(byte[] buffer, int offset, int length, int messageBoundary) throws IOException {
            this.out.write(buffer, offset, length, messageBoundary);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }
    }

    static final class PairedWireFactory
    implements Wire.Factory {
        final Object mutex;
        final Queue<Wire> wireQueue = new LinkedList<Wire>();
        PairedWireFactory pair;
        BehaviorSubject<Wire.Factory> pairSubject;

        PairedWireFactory(Object mutex) {
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Wire create(@Nullable Wire replace) throws InterruptedException, NoSuchElementException {
            Wire wire;
            Object object = this.mutex;
            synchronized (object) {
                wire = this.wireQueue.poll();
                if (null != wire) {
                    return wire;
                }
                Wire a = Wires.transfer();
                Wire b = Wires.transfer();
                wire = new PairWire(a, b);
                this.pair.wireQueue.add(new PairWire(b, a));
            }
            this.pairSubject.onNext((Object)this.pair);
            return wire;
        }
    }
}

