/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.util;

import java.io.OutputStream;

public class NoCopyByteArrayOutputStream
extends OutputStream {
    private byte[] buffer;
    private int bufferOffset;
    private int bufferHead;
    private final byte[] one = new byte[1];

    public NoCopyByteArrayOutputStream(int size) {
        this(new byte[size]);
    }

    public NoCopyByteArrayOutputStream(byte[] buffer) {
        this(buffer, 0);
    }

    public NoCopyByteArrayOutputStream(byte[] buffer, int offset) {
        if (buffer.length < offset) {
            throw new IllegalArgumentException();
        }
        this.buffer = buffer;
        this.bufferOffset = offset;
        this.bufferHead = offset;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    public int getOffset() {
        return this.bufferOffset;
    }

    public int getLength() {
        return this.bufferHead - this.bufferOffset;
    }

    public byte[] toByteArray() {
        int n = this.bufferHead - this.bufferOffset;
        byte[] copy = new byte[n];
        System.arraycopy(this.buffer, this.bufferOffset, copy, 0, n);
        return copy;
    }

    @Override
    public void write(int b) {
        this.one[0] = (byte)b;
        this.write(this.one, 0, 1);
    }

    @Override
    public void write(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) {
        if (bytes.length < offset + length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.buffer.length < this.bufferHead + length) {
            int n;
            int i = this.bufferHead - this.bufferOffset;
            for (n = this.buffer.length - this.bufferOffset; n < i + length; n *= 2) {
            }
            byte[] newBuffer = new byte[n];
            System.arraycopy(this.buffer, this.bufferOffset, newBuffer, 0, i);
            this.buffer = newBuffer;
            this.bufferOffset = 0;
            this.bufferHead = i;
        }
        System.arraycopy(bytes, offset, this.buffer, this.bufferHead, length);
        this.bufferHead += length;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

