/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.util;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class MoreExecutors {
    public static Executor serial(Executor delegate) {
        return new SerialExecutor(delegate);
    }

    private static final class SerialExecutor
    implements Executor {
        private final Executor delegate;
        private final Queue<Runnable> queue = new LinkedList<Runnable>();
        private final Object mutex = new Object();
        @Nullable
        private Runnable active = null;

        SerialExecutor(Executor delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            Runnable pending;
            Object object = this.mutex;
            synchronized (object) {
                this.queue.add(command);
                pending = null == this.active ? (this.active = new Reactor()) : null;
            }
            if (null != pending) {
                this.delegate.execute(pending);
            }
        }

        private final class Reactor
        implements Runnable {
            private Reactor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Runnable r;
                do {
                    Object object = SerialExecutor.this.mutex;
                    synchronized (object) {
                        r = (Runnable)SerialExecutor.this.queue.poll();
                        if (null == r) {
                            SerialExecutor.this.active = null;
                        }
                    }
                    if (null == r) continue;
                    r.run();
                } while (null != r);
            }
        }
    }
}

