/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.util;

import java.nio.CharBuffer;

public class HexBytes {
    private static final char[] nibbleToHex;
    private static final int[] hexToNibble;
    private static final char[][] byteToHex;

    public static byte[] valueOf(String s) {
        int n = s.length();
        byte[] bytes = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            int a = hexToNibble[s.charAt(i)];
            if (a < 0) {
                throw new IllegalArgumentException();
            }
            int b = hexToNibble[s.charAt(i + 1)];
            if (b < 0) {
                throw new IllegalArgumentException();
            }
            bytes[i / 2] = (byte)(a << 4 | b);
        }
        return bytes;
    }

    public static String toString(byte[] bytes) {
        return HexBytes.toString(bytes, 0, bytes.length);
    }

    public static String toString(byte[] bytes, int offset, int length) {
        CharBuffer cb = CharBuffer.allocate(2 * length);
        HexBytes.toString(bytes, offset, length, cb);
        return new String(cb.array());
    }

    public static void toString(byte[] bytes, int offset, int n, CharBuffer cb) {
        for (int i = 0; i < n; ++i) {
            cb.put(byteToHex[0xFF & bytes[offset + i]]);
        }
    }

    static {
        int i;
        nibbleToHex = new char[16];
        for (i = 0; i < 16; ++i) {
            HexBytes.nibbleToHex[i] = Character.toLowerCase(Integer.toHexString(i).charAt(0));
        }
        hexToNibble = new int[128];
        int n = hexToNibble.length;
        for (i = 0; i < n; ++i) {
            HexBytes.hexToNibble[i] = -1;
        }
        for (i = 0; i < 16; ++i) {
            HexBytes.hexToNibble[Character.toLowerCase((char)HexBytes.nibbleToHex[i])] = i;
            HexBytes.hexToNibble[Character.toUpperCase((char)HexBytes.nibbleToHex[i])] = i;
        }
        byteToHex = new char[256][];
        for (i = 0; i < 256; ++i) {
            HexBytes.byteToHex[i] = new char[]{nibbleToHex[i >>> 4 & 0xF], nibbleToHex[i & 0xF]};
        }
    }
}

