/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.sortedlist;

import com.google.common.collect.Ordering;
import io.nextop.sortedlist.SortedList;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;

public final class SplaySortedList<E>
extends AbstractList<E>
implements SortedList<E> {
    private final Comparator<? super E> comparator;
    @Nullable
    private Node<E> root;
    private final Node<E> header = new Node<Object>(null);

    public SplaySortedList() {
        this((Comparator<E>)Ordering.natural());
    }

    public SplaySortedList(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    E search(int index) {
        int c;
        if (null == this.root || index < 0 || this.root.count <= index) {
            throw new IndexOutOfBoundsException();
        }
        Node<Object> y = this.root;
        while (0 != (c = index - (null != y.left ? y.left.count : 0))) {
            if (c < 0) {
                y = y.left;
                continue;
            }
            index -= 1 + (null != y.left ? y.left.count : 0);
            y = y.right;
        }
        return (E)y.value;
    }

    FindResult<E> search(E value) {
        return this.search(SplaySortedList.comparable(value, this.comparator));
    }

    FindResult<E> search(Comparable<? super E> q) {
        int c;
        if (null == this.root) {
            return new FindResult<Object>(null, -1, 1);
        }
        int index = 0;
        Node<Object> y = this.root;
        while (0 != (c = q.compareTo(y.value))) {
            if (c < 0) {
                if (null == y.left) break;
                y = y.left;
                continue;
            }
            if (null == y.right) break;
            index += 1 + (null != y.left ? y.left.count : 0);
            y = y.right;
        }
        return new FindResult(y.value, index += null != y.left ? y.left.count : 0, c);
    }

    private void splay(E value) {
        int c;
        Node<E> r;
        Node<E> l = r = this.header;
        Node<Object> t = this.root;
        this.header.right = null;
        this.header.left = null;
        this.header.count = 0;
        while (0 != (c = this.comparator.compare(value, t.value))) {
            Node y;
            if (c < 0) {
                if (null == t.left) break;
                if (this.comparator.compare(value, t.left.value) < 0) {
                    y = t.left;
                    t.left = y.right;
                    y.right = t;
                    y.count = y.count + (1 + (null != t.right ? t.right.count : 0));
                    t.count = t.count - (1 + (null != y.left ? y.left.count : 0));
                    t = y;
                    if (null == t.left) break;
                }
                r.left = t;
                r = t;
                t = t.left;
                continue;
            }
            if (null == t.right) break;
            if (0 < this.comparator.compare(value, t.right.value)) {
                y = t.right;
                t.right = y.left;
                y.left = t;
                y.count = y.count + (1 + (null != t.left ? t.left.count : 0));
                t.count = t.count - (1 + (null != y.right ? y.right.count : 0));
                t = y;
                if (null == t.right) break;
            }
            l.right = t;
            l = t;
            t = t.right;
        }
        l.right = t.left;
        r.left = t.right;
        t.left = this.header.right;
        t.right = this.header.left;
        this.resetLrCounts(t);
        t.count = 1 + (null != t.left ? t.left.count : 0) + (null != t.right ? t.right.count : 0);
        this.root = t;
    }

    private void splay(int index) {
        int c;
        Node<E> r;
        Node<E> l = r = this.header;
        Node<Object> t = this.root;
        this.header.right = null;
        this.header.left = null;
        this.header.count = 0;
        while (0 != (c = index - (null != t.left ? t.left.count : 0))) {
            Node y;
            if (c < 0) {
                if (null == t.left) break;
                if (index - (null != t.left.left ? t.left.left.count : 0) < 0) {
                    y = t.left;
                    t.left = y.right;
                    y.right = t;
                    y.count = y.count + (1 + (null != t.right ? t.right.count : 0));
                    t.count = t.count - (1 + (null != y.left ? y.left.count : 0));
                    t = y;
                    if (null == t.left) break;
                }
                r.left = t;
                r = t;
                t = t.left;
                continue;
            }
            index -= 1 + (null != t.left ? t.left.count : 0);
            if (null == t.right) break;
            if (0 < index - (null != t.right.left ? t.right.left.count : 0)) {
                index -= 1 + (null != t.right.left ? t.right.left.count : 0);
                y = t.right;
                t.right = y.left;
                y.left = t;
                y.count = y.count + (1 + (null != t.left ? t.left.count : 0));
                t.count = t.count - (1 + (null != y.right ? y.right.count : 0));
                t = y;
                if (null == t.right) break;
            }
            l.right = t;
            l = t;
            t = t.right;
        }
        l.right = t.left;
        r.left = t.right;
        t.left = this.header.right;
        t.right = this.header.left;
        this.resetLrCounts(t);
        t.count = 1 + (null != t.left ? t.left.count : 0) + (null != t.right ? t.right.count : 0);
        this.root = t;
    }

    private void resetLrCounts(Node<E> n) {
        int c = 0;
        Node y = n.left;
        while (null != y) {
            ++c;
            if (null != y.right) {
                if (null != y.left) {
                    c += y.left.count;
                }
                y = y.right;
                continue;
            }
            y = y.left;
        }
        y = n.left;
        while (null != y) {
            y.count = c--;
            if (null != y.right) {
                if (null != y.left) {
                    c -= y.left.count;
                }
                y = y.right;
                continue;
            }
            y = y.left;
        }
        c = 0;
        y = n.right;
        while (null != y) {
            ++c;
            if (null != y.left) {
                if (null != y.right) {
                    c += y.right.count;
                }
                y = y.left;
                continue;
            }
            y = y.right;
        }
        y = n.right;
        while (null != y) {
            y.count = c--;
            if (null != y.left) {
                if (null != y.right) {
                    c -= y.right.count;
                }
                y = y.left;
                continue;
            }
            y = y.right;
        }
    }

    @Override
    @Nullable
    public E lower(E value) {
        return this.lower(SplaySortedList.comparable(value, this.comparator));
    }

    @Override
    @Nullable
    public E lower(Comparable<? super E> q) {
        FindResult<? super E> r = this.search(q);
        if (0 < r.c) {
            return (E)r.value;
        }
        if (0 < r.index) {
            return this.get(r.index - 1);
        }
        return null;
    }

    @Override
    public int lowerIndex(E value) {
        return this.lowerIndex(SplaySortedList.comparable(value, this.comparator));
    }

    @Override
    public int lowerIndex(Comparable<? super E> q) {
        FindResult<? super E> r = this.search(q);
        if (0 < r.c) {
            return r.index;
        }
        return r.index - 1;
    }

    @Override
    @Nullable
    public E floor(E value) {
        return this.floor(SplaySortedList.comparable(value, this.comparator));
    }

    @Override
    @Nullable
    public E floor(Comparable<? super E> q) {
        FindResult<? super E> r = this.search(q);
        if (0 <= r.c) {
            return (E)r.value;
        }
        if (0 < r.index) {
            return this.get(r.index - 1);
        }
        return null;
    }

    @Override
    public int floorIndex(E value) {
        return this.floorIndex(SplaySortedList.comparable(value, this.comparator));
    }

    @Override
    public int floorIndex(Comparable<? super E> q) {
        FindResult<? super E> r = this.search(q);
        if (0 <= r.c) {
            return r.index;
        }
        return r.index - 1;
    }

    @Override
    @Nullable
    public E higher(E value) {
        return this.higher(SplaySortedList.comparable(value, this.comparator));
    }

    @Override
    @Nullable
    public E higher(Comparable<? super E> q) {
        FindResult<? super E> r = this.search(q);
        if (r.c < 0) {
            return (E)r.value;
        }
        if (r.index + 1 < this.size()) {
            return this.get(r.index + 1);
        }
        return null;
    }

    @Override
    public int higherIndex(E value) {
        return this.higherIndex(SplaySortedList.comparable(value, this.comparator));
    }

    @Override
    public int higherIndex(Comparable<? super E> q) {
        FindResult<? super E> r = this.search(q);
        if (r.c < 0) {
            return r.index;
        }
        return r.index + 1;
    }

    @Override
    @Nullable
    public E ceiling(E value) {
        return this.ceiling(SplaySortedList.comparable(value, this.comparator));
    }

    @Override
    @Nullable
    public E ceiling(Comparable<? super E> q) {
        FindResult<? super E> r = this.search(q);
        if (r.c <= 0) {
            return (E)r.value;
        }
        if (r.index + 1 < this.size()) {
            return this.get(r.index + 1);
        }
        return null;
    }

    @Override
    public int ceilingIndex(E value) {
        return this.ceilingIndex(SplaySortedList.comparable(value, this.comparator));
    }

    @Override
    public int ceilingIndex(Comparable<? super E> q) {
        FindResult<? super E> r = this.search(q);
        if (r.c <= 0) {
            return r.index;
        }
        return r.index + 1;
    }

    @Override
    public boolean insertAll(Collection<? extends E> values) {
        boolean m = false;
        for (E value : values) {
            m |= this.insert(value);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(E value) {
        if (null == value) {
            throw new NullPointerException();
        }
        try {
            if (null == this.root) {
                this.root = new Node<E>(value);
                boolean bl = true;
                return bl;
            }
            this.splay(value);
            int c = this.comparator.compare(value, this.root.value);
            if (0 == c) {
                boolean bl = false;
                return bl;
            }
            Node<E> n = new Node<E>(value);
            n.count += this.root.count;
            if (c < 0) {
                n.right = this.root;
                if (null != this.root.left) {
                    this.root.count -= this.root.left.count;
                    n.left = this.root.left;
                    this.root.left = null;
                }
            } else {
                n.left = this.root;
                if (null != this.root.right) {
                    this.root.count -= this.root.right.count;
                    n.right = this.root.right;
                    this.root.right = null;
                }
            }
            this.root = n;
            boolean bl = true;
            return bl;
        }
        finally {
            assert (this.checkInvariants());
        }
    }

    @Override
    public int size() {
        return null != this.root ? this.root.count : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object value) {
        if (null == value) {
            return false;
        }
        try {
            int i = this.search(value).c;
            boolean bl = 0 == i;
            return bl;
        }
        finally {
            assert (this.checkInvariants());
        }
    }

    @Override
    public int indexOf(Comparable<? super E> q) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Comparable<? super E> q) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object value) {
        if (null == value) {
            return -1;
        }
        try {
            FindResult<Object> r = this.search(value);
            int n = 0 == r.c ? r.index : -1;
            return n;
        }
        finally {
            assert (this.checkInvariants());
        }
    }

    @Override
    public E get(int index) {
        try {
            if (null == this.root || index < 0 || this.root.count <= index) {
                throw new IndexOutOfBoundsException("" + index);
            }
            this.splay(index);
            assert ((null != this.root.left ? this.root.left.count : 0) == index) : "Expected root index " + index + " but found " + (null != this.root.left ? this.root.left.count : 0);
            Object t = this.root.value;
            return (E)t;
        }
        finally {
            assert (this.checkInvariants());
        }
    }

    @Override
    public void add(int location, E object) {
        throw new UnsupportedOperationException("Inserting by index is not supported in a sorted list.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        try {
            if (null == this.root || index < 0 || this.root.count <= index) {
                throw new IndexOutOfBoundsException();
            }
            this.splay(index);
            Object value = this.root.value;
            if (null == this.root.left) {
                this.root = this.root.right;
            } else {
                Node t = this.root.right;
                this.root = this.root.left;
                this.splay(index);
                this.root.right = t;
                if (null != t) {
                    this.root.count += t.count;
                }
            }
            Object t = value;
            return (E)t;
        }
        finally {
            assert (this.checkInvariants());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object value) {
        if (null == value) {
            throw new NullPointerException();
        }
        try {
            if (null == this.root) {
                boolean bl = false;
                return bl;
            }
            this.splay(value);
            int c = this.comparator.compare(value, this.root.value);
            if (0 != c) {
                boolean bl = false;
                return bl;
            }
            if (null == this.root.left) {
                this.root = this.root.right;
            } else {
                Node t = this.root.right;
                this.root = this.root.left;
                this.splay(value);
                this.root.right = t;
                if (null != t) {
                    this.root.count += t.count;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            assert (this.checkInvariants());
        }
    }

    @Override
    public void clear() {
        try {
            this.root = null;
        }
        finally {
            assert (this.checkInvariants());
        }
    }

    public boolean checkInvariants() {
        if (null != this.root && this.size() < 128) {
            this._checkCount(this.root);
            this._checkBst(this.root);
        }
        return true;
    }

    private int _checkCount(Node<E> n) {
        int expectedCount = 1;
        if (null != n.left) {
            expectedCount += this._checkCount(n.left);
        }
        if (null != n.right) {
            expectedCount += this._checkCount(n.right);
        }
        assert (expectedCount == n.count) : String.format("%d <> %d", expectedCount, n.count);
        return expectedCount;
    }

    private void _checkBst(Node<E> n) {
        if (null != n.left) {
            assert (this.comparator.compare(n.left.value, n.value) <= 0) : String.format("%s <> %s (%d)", n.left.value, n.value, this.comparator.compare(n.left.value, n.value));
            this._checkBst(n.left);
        }
        if (null != n.right) {
            assert (0 <= this.comparator.compare(n.right.value, n.value)) : String.format("%s <> %s (%d)", n.right.value, n.value, this.comparator.compare(n.right.value, n.value));
            this._checkBst(n.right);
        }
    }

    private static <T> Comparable<T> comparable(final T value, final Comparator<? super T> comparator) {
        return new Comparable<T>(){

            @Override
            public int compareTo(T another) {
                return comparator.compare(value, another);
            }
        };
    }

    private static <T> boolean isMonotonicallyIncreasing(Iterator<T> sortedItr, Comparable<? super T> q) {
        if (!sortedItr.hasNext()) {
            return true;
        }
        int ps = -1;
        while (sortedItr.hasNext()) {
            int s;
            int c = q.compareTo(sortedItr.next());
            int n = c < 0 ? -1 : (s = 0 < c ? 1 : 0);
            if (s < ps) {
                return false;
            }
            ps = s;
        }
        return true;
    }

    static final class FindResult<T> {
        public final T value;
        public final int index;
        public final int c;

        FindResult(T value, int index, int c) {
            this.value = value;
            this.index = index;
            this.c = c;
        }
    }

    private static final class Node<T> {
        @Nullable
        final T value;
        int count = 1;
        @Nullable
        Node<T> left = null;
        @Nullable
        Node<T> right = null;

        Node(@Nullable T value) {
            this.value = value;
        }
    }
}

