/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.log;

import io.nextop.log.Log;
import io.nextop.log.LogEntry;
import java.util.EnumSet;
import java.util.logging.Level;
import javax.annotation.Nullable;

public final class Outs {
    public static final int DEFAULT_LINE_WIDTH = 90;
    public static final int DEFAULT_KEY_WIDTH = 32;
    public static final int DEFAULT_VALUE_WIDTH = 8;
    public static final int DEFAULT_UNIT_WIDTH = 6;

    public static Log.Out split(@Nullable Log.Out console, @Nullable Log.Out upstream) {
        return new SplitOut(console, upstream);
    }

    public static Log.Out mask(Log.Out out, EnumSet<LogEntry.Type> allowedConsole, EnumSet<LogEntry.Type> allowedUp) {
        return new MaskedOut(out, allowedConsole, allowedUp);
    }

    public static Log.Out sysout() {
        return new SysOut();
    }

    public static Log.Out empty() {
        return new EmptyOut();
    }

    private Outs() {
    }

    private static final class EmptyOut
    implements Log.Out {
        EmptyOut() {
        }

        @Override
        public boolean isWrite(Level level, LogEntry.Type type) {
            return false;
        }

        @Override
        public int lineWidth() {
            return 90;
        }

        @Override
        public int keyWidth() {
            return 32;
        }

        @Override
        public int valueWidth() {
            return 8;
        }

        @Override
        public int unitWidth() {
            return 6;
        }

        @Override
        public void write(Level level, LogEntry.Type type, String ... lines) {
        }

        @Override
        public boolean isWriteUp(Level level, LogEntry.Type type) {
            return false;
        }

        @Override
        public void writeUp(LogEntry entry) {
        }
    }

    private static final class SysOut
    implements Log.Out {
        SysOut() {
        }

        @Override
        public boolean isWrite(Level level, LogEntry.Type type) {
            return true;
        }

        @Override
        public int lineWidth() {
            return 90;
        }

        @Override
        public int keyWidth() {
            return 32;
        }

        @Override
        public int valueWidth() {
            return 8;
        }

        @Override
        public int unitWidth() {
            return 6;
        }

        @Override
        public void write(Level level, LogEntry.Type type, String ... lines) {
            int n = lines.length;
            if (n <= 0) {
                return;
            }
            String prefix = String.format("[%s] ", level);
            int net = 0;
            for (int i = 0; i < n; ++i) {
                net += prefix.length() + lines[i].length() + 1;
            }
            StringBuilder sb = new StringBuilder(net);
            for (String line : lines) {
                sb.append(line).append('\n');
            }
            System.out.print(sb.toString());
        }

        @Override
        public boolean isWriteUp(Level level, LogEntry.Type type) {
            return false;
        }

        @Override
        public void writeUp(LogEntry entry) {
        }
    }

    private static final class MaskedOut
    implements Log.Out {
        private final Log.Out impl;
        private final EnumSet<LogEntry.Type> allowedConsole;
        private final EnumSet<LogEntry.Type> allowedUp;

        public MaskedOut(Log.Out impl, EnumSet<LogEntry.Type> allowedConsole, EnumSet<LogEntry.Type> allowedUp) {
            this.impl = impl;
            this.allowedConsole = allowedConsole;
            this.allowedUp = allowedUp;
        }

        @Override
        public boolean isWrite(Level level, LogEntry.Type type) {
            return this.allowedConsole.contains((Object)type) && this.impl.isWrite(level, type);
        }

        @Override
        public int lineWidth() {
            return this.impl.lineWidth();
        }

        @Override
        public int keyWidth() {
            return this.impl.keyWidth();
        }

        @Override
        public int valueWidth() {
            return this.impl.valueWidth();
        }

        @Override
        public int unitWidth() {
            return this.impl.unitWidth();
        }

        @Override
        public void write(Level level, LogEntry.Type type, String ... lines) {
            if (this.isWrite(level, type)) {
                this.impl.write(level, type, lines);
            }
        }

        @Override
        public boolean isWriteUp(Level level, LogEntry.Type type) {
            return this.allowedUp.contains((Object)type) && this.impl.isWriteUp(level, type);
        }

        @Override
        public void writeUp(LogEntry entry) {
            if (this.isWriteUp(entry.level, entry.type)) {
                this.impl.writeUp(entry);
            }
        }
    }

    private static final class SplitOut
    implements Log.Out {
        @Nullable
        private final Log.Out console;
        @Nullable
        private final Log.Out upstream;

        public SplitOut(@Nullable Log.Out console, @Nullable Log.Out upstream) {
            this.console = console;
            this.upstream = upstream;
        }

        @Override
        public boolean isWrite(Level level, LogEntry.Type type) {
            return null != this.console && this.console.isWrite(level, type);
        }

        @Override
        public int lineWidth() {
            if (null != this.console) {
                return this.console.lineWidth();
            }
            return 90;
        }

        @Override
        public int keyWidth() {
            if (null != this.console) {
                return this.console.keyWidth();
            }
            return 32;
        }

        @Override
        public int valueWidth() {
            if (null != this.console) {
                return this.console.valueWidth();
            }
            return 8;
        }

        @Override
        public int unitWidth() {
            if (null != this.console) {
                return this.console.unitWidth();
            }
            return 6;
        }

        @Override
        public void write(Level level, LogEntry.Type type, String ... lines) {
            if (this.isWrite(level, type)) {
                this.console.write(level, type, lines);
            }
        }

        @Override
        public boolean isWriteUp(Level level, LogEntry.Type type) {
            return null != this.upstream && this.upstream.isWriteUp(level, type);
        }

        @Override
        public void writeUp(LogEntry entry) {
            if (this.isWriteUp(entry.level, entry.type)) {
                this.upstream.writeUp(entry);
            }
        }
    }
}

